<?php

/**
 * Plugin Name: Review Wall
 * Description: A smart plugin to collect and manage Google Reviews effectively.
 * Version:     1.3.4
 * Author:      Norml Studio
 * Author URI:  https://norml.studio/
 * License:     GPL-2.0+
 * Text Domain: review-wall
 * Domain Path: /languages
 */

defined('ABSPATH') || exit;

// Define constants
define('REVIEW_WALL_VERSION', '1.2.0');
define('REVIEW_WALL_API_URL', 'https://reviewswall.com');
define('REVIEWS_WALL_PATH', plugin_dir_path(__FILE__));
define('REVIEWS_WALL_URL', plugin_dir_url(__FILE__));

// Include the main plugin file
require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall.php';
require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-activation.php';
require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-deactivation.php';

// Register activation hooks
register_activation_hook(__FILE__, ['Review_Wall_Activation', 'activate']);

// Register deactivation hooks
register_deactivation_hook(__FILE__, ['Review_Wall_Deactivation', 'deactivate']);

// Run the plugin
Review_Wall::init();
