<?php

defined('ABSPATH') || exit;

// Process form submissions
Review_Wall_Form_Handler::process_form_submission();

// Get license settings
$review_wall_api_key = get_option('review_wall_api_key');
$license_status      = get_option('review_wall_license_status', 'invalid');
$status_color        = ($license_status === 'valid') ? '#00a32a' : '#d63638';

?>

<div class="wrap review-wall-admin-wrap">
    <h1><?php esc_html_e('Review Wall', 'review-wall'); ?></h1>

    <div class="review-wall-admin-container">
        <div class="review-wall-section">
            <h2><?php esc_html_e('How to Use Review Wall', 'review-wall'); ?></h2>

            <p><?php esc_html_e('Review Wall helps you collect and manage Google Reviews effectively. Follow these steps to get started:', 'review-wall'); ?></p>

            <h3><?php esc_html_e('Set a Default Google Review URL (Required)', 'review-wall'); ?></h3>
            <p>
                <?php esc_html_e('Before creating multiple review URLs, you must enter a default Google Review URL in the "Global Settings" section. This is a required field, and the plugin will not work properly without it.', 'review-wall'); ?>
            </p>
            <p>
                <?php esc_html_e('The default URL serves as a fallback in case a user visits the feedback page with an incorrect key or without any URL key at all. In such cases, the plugin automatically redirects the user to this default Google Review page.', 'review-wall'); ?>
            </p>
            <p>
                <strong><?php esc_html_e('Example:', 'review-wall'); ?></strong><br>
                <code>https://www.google.com/maps/place/YourBusiness/reviews</code>
            </p>
            <p>
                <?php esc_html_e('Without a default URL, your review collection links cannot function, so this field must be filled first before creating any additional review URLs.', 'review-wall'); ?>
            </p>

            <h3><?php esc_html_e('Access the Feedback Page', 'review-wall'); ?></h3>
            <p>
                <?php esc_html_e('All review links redirect customers to your Feedback page. You can visit it here:', 'review-wall'); ?><br>
                <a href="<?php echo esc_url(Review_Wall_Page_Manager::get_page_url()); ?>" target="_blank"><?php echo esc_url(Review_Wall_Page_Manager::get_page_url()); ?></a><br>
                <?php esc_html_e('If you created multiple URLs, use the format:', 'review-wall'); ?><br>
                <code><?php echo esc_url(site_url('/feedback/?id=your_unique_key')); ?></code>
            </p>

            <h3><?php esc_html_e('Why You Might Need Multiple URLs', 'review-wall'); ?></h3>
            <p><?php esc_html_e('You can create multiple unique review URLs for different Google accounts, locations, or products. This allows you to collect reviews separately and direct them to the correct Google Review page.', 'review-wall'); ?></p>

            <ul>
                <li><strong><?php esc_html_e('Different Google Accounts:', 'review-wall'); ?></strong> <?php esc_html_e('If you manage multiple Google My Business accounts, each URL can point to a specific account.', 'review-wall'); ?></li>
                <li><strong><?php esc_html_e('Different Locations or Products:', 'review-wall'); ?></strong> <?php esc_html_e('You can create a unique URL for each location or product, so reviews are collected separately and do not mix.', 'review-wall'); ?></li>
            </ul>

            <p><?php esc_html_e('Each URL has a unique key (URL Key). The link format is:', 'review-wall'); ?> <code>yourdomain.com/feedback/?id=unique_key</code></p>
            <p><?php esc_html_e('If the key is missing or invalid, the plugin will use your default Google Review URL as a fallback.', 'review-wall'); ?></p>

            <h3><?php esc_html_e('Create Your First Review URL', 'review-wall'); ?></h3>
            <ol>
                <li><?php esc_html_e('Go to the "Add New URL" section above.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Enter a name for the review destination (e.g., "Main Location").', 'review-wall'); ?></li>
                <li><?php esc_html_e('Enter or auto-generate a unique URL key.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Enter your Google Review URL.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Click "Add URL".', 'review-wall'); ?></li>
            </ol>

            <h3><?php esc_html_e('Share Review Links', 'review-wall'); ?></h3>
            <ul>
                <li><?php esc_html_e('Include in email signatures.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Add to business cards.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Use in follow-up emails after purchases.', 'review-wall'); ?></li>
                <li><?php esc_html_e('Generate QR codes for physical locations.', 'review-wall'); ?></li>
            </ul>

            <h3><?php esc_html_e('Manage Customer Feedback', 'review-wall'); ?></h3>
            <p><?php esc_html_e('Positive reviews (above your rating threshold) are automatically sent to Google. Negative feedback is captured on your website for internal use. You can view all feedback in the admin area.', 'review-wall'); ?></p>

            <h3><?php esc_html_e('Display Reviews on Your Site', 'review-wall'); ?></h3>
            <p>
                <?php esc_html_e('Use the shortcode', 'review-wall'); ?>
                <code>[review_wall_google_reviews]</code>
                <?php esc_html_e('to display a widget with your synced Google Reviews, average rating, total reviews, and a link to your Google Review page.', 'review-wall'); ?>
            </p>
        </div>

        <div class="review-wall-section">
            <h2><?php esc_html_e('License', 'review-wall'); ?></h2>

            <form class="review-wall-form" method="post" action="">
                <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
                <input type="hidden" name="review_wall_submit_action" value="save_api_key_settings">

                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="review_wall_api_key"><?php esc_html_e('API Key', 'review-wall'); ?></label>
                        </th>
                        <td>
                            <input type="text" name="review_wall_api_key" id="review_wall_api_key"
                                value="<?php echo esc_attr($review_wall_api_key); ?>"
                                class="regular-text">

                            <p class="description">
                                <?php esc_html_e('Enter your API key here to activate the premium features of the plugin.', 'review-wall'); ?>
                            </p>

                            <p class="description">
                                <?php
                                // translators: %s is the URL to the plugin site.
                                printf(wp_kses(__('Your API key is provided on your account page on the official <a href="%s" target="_blank" rel="noopener noreferrer">plugin site</a>.', 'review-wall'), ['a' => ['href' => [], 'target' => [], 'rel' => []]]), esc_url(REVIEW_WALL_API_URL));
                                ?>
                            </p>

                            <p class="description" style="margin-top:10px; font-style: italic; color: #555;">
                                <?php esc_html_e('Example API key format:', 'review-wall'); ?> <code>xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx</code>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e('License Status', 'review-wall'); ?></th>
                        <td>
                            <strong style="color: <?php echo esc_attr($status_color); ?>;">
                                <?php echo esc_html(ucfirst($license_status)); ?>
                            </strong>
                            <p class="description"><?php esc_html_e('Shows whether your API key license is valid or invalid.', 'review-wall'); ?></p>
                        </td>
                    </tr>
                </table>

                <p class="submit">
                    <input type="submit" name="submit" class="button button-primary" value="<?php esc_html_e('Save Key', 'review-wall'); ?>">
                </p>
            </form>
        </div>
    </div>
</div>