<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Shortcode
 *
 * Handles the shortcode for rendering the review wall template
 */
class Review_Wall_Shortcode
{
    /**
     * Initialize shortcode
     */
    public static function init()
    {
        // Add review wall shortcode
        add_shortcode('review_wall', [self::class, 'render_review_wall']);

        // Add Google Reviews widget shortcode
        add_shortcode('review_wall_google_reviews', [self::class, 'render_google_reviews_widget']);
    }

    /**
     * Render review wall template via shortcode
     *
     * @return string Rendered template content
     */
    public static function render_review_wall()
    {
        ob_start();

        require_once REVIEWS_WALL_PATH . '/templates/review-page-template.php';

        return ob_get_clean();
    }

    /**
     * Render the Google Reviews slider/widget
     *
     * @return string Rendered reviews HTML
     */
    public static function render_google_reviews_widget()
    {
        ob_start();

        require_once REVIEWS_WALL_PATH . '/templates/google-reviews-widget.php';

        return ob_get_clean();
    }
}
