<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Settings
 *
 * Centralized options management.
 */
class Review_Wall_Settings
{
    /**
     * All plugin options with defaults.
     *
     * @return array
     */
    public static function get_options()
    {
        return [
            // General settings
            'review_wall_api_key'                     => '', // Google API key
            'review_wall_license_key'                 => '', // Plugin license key
            'review_wall_license_status'              => 'inactive', // License status: active/inactive
            'review_wall_logo'                        => '', // Logo URL
            'review_wall_rating_threshold'            => 3, // Minimum rating to show positive feedback
            'review_wall_default_url'                 => '', // Default redirect URL

            // Google data
            'review_wall_google_average_rating'       => '', // Average Google rating
            'review_wall_google_total_reviews'        => '', // Total number of Google reviews
            'review_wall_google_reviews_link'         => '', // Google Place ID URL (used to fetch reviews)
            'review_wall_google_connection_status'    => '', // Google API connection status
            'review_wall_google_last_sync'            => '', // Last sync timestamp

            // Form step 1
            'review_wall_title_step_1'                => 'Your thoughts are important to us!', // Step 1 title
            'review_wall_description_step_1'          => 'Thank you for choosing us! Share your impressions...', // Step 1 description
            'review_wall_btn_step_1'                  => 'Continue', // Step 1 button text

            // Form step 2
            'review_wall_title_step_2'                => 'We are very sorry that you were not satisfied :(', // Step 2 title
            'review_wall_description_step_2'          => 'Your assessment shows that something went wrong...', // Step 2 description
            'review_wall_comment_label'               => 'Your comment', // Step 2 comment field label
            'review_wall_email_label'                 => 'Your email', // Step 2 email field label
            'review_wall_btn_step_2'                  => 'Leave a review', // Step 2 button text

            // Form step 3
            'review_wall_title_step_3'                => 'Thank you for your feedback!', // Step 3 title
            'review_wall_btn_step_3'                  => 'Home', // Step 3 button text

            // Widget settings
            'review_wall_widget_btn_link'             => '', // Widget button URL
            'review_wall_widget_title'                => 'See what our clients are saying', // Widget title
            'review_wall_widget_btn_text'             => 'Review us on Google', // Widget button text
            'review_wall_widget_read_more_text'       => 'Read more', // Widget "read more" text
            'review_wall_widget_bg_color'             => '#ffffff', // Widget background color
            'review_wall_widget_btn_text_color'       => '#ffffff', // Widget button text color
            'review_wall_widget_btn_bg_color'         => '#1a7bff', // Widget button background color
            'review_wall_widget_btn_hover_text_color' => '#ffffff', // Widget button hover text color
            'review_wall_widget_btn_hover_bg_color'   => '#156ae0', // Widget button hover background color
        ];
    }

    /**
     * Register options in WP Settings API.
     */
    public static function register_settings()
    {
        foreach (self::get_options() as $option => $default) {
            register_setting('review_wall_options', $option);
        }
    }

    /**
     * Add defaults on plugin activation.
     */
    public static function add_default_options()
    {
        foreach (self::get_options() as $option => $default) {
            if (get_option($option) === false) {
                add_option($option, $default);
            }
        }
    }

    /**
     * Delete all options on uninstall.
     */
    public static function delete_options()
    {
        foreach (self::get_options() as $option => $default) {
            delete_option($option);
        }
    }
}
