<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Helper
 * 
 * Helper class for the Review Wall plugin, providing utility methods
 */
class Review_Wall_Helper
{
    /**
     * Holds the singleton instance of Review_Wall_DB.
     *
     * @var Review_Wall_DB|null
     */
    private static $db_instance;

    /**
     * Get the singleton instance of Review_Wall_DB
     *
     * @return Review_Wall_DB
     */
    public static function get_db_instance()
    {
        if (self::$db_instance === null) {
            // Ensure the class file is included
            require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-db.php';
            self::$db_instance = new Review_Wall_DB();
        }

        return self::$db_instance;
    }

    /**
     * Helper function to get photo URL
     * Supports both ID (from manual upload) and URL (from Google)
     *
     * @param mixed $photo_value Photo ID or URL
     * @return string|false Photo URL or false if not found
     */
    public static function get_photo_url($photo_value)
    {
        if (empty($photo_value)) {
            return false;
        }

        if (is_numeric($photo_value)) {
            $url = wp_get_attachment_url($photo_value);
            return $url ? $url : false;
        }

        if (filter_var($photo_value, FILTER_VALIDATE_URL)) {
            return $photo_value;
        }

        return false;
    }
}
