<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Deactivation
 * 
 * Fired during plugin deactivation.
 */
class Review_Wall_Deactivation
{
    /**
     * Deactivate the plugin.
     *
     * Deactivates the review page and flushes rewrite rules.
     */
    public static function deactivate()
    {
        // Deactivate the review wall page (set to draft)
        self::deactivate_review_page();

        // Remove Google Reviews cron
        self::remove_google_cron();

        // Flush rewrite rules to remove the custom post type URL structure
        flush_rewrite_rules();
    }

    /**
     * Deactivate the review wall page.
     */
    private static function deactivate_review_page()
    {
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-page-manager.php';
        Review_Wall_Page_Manager::deactivate_page();
    }

    /**
     * Remove Google Reviews cron job.
     */
    private static function remove_google_cron()
    {
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-google-api.php';
        Review_Wall_Google_Api::remove_cron();
    }
}
