<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Ajax_Admin
 *
 * Handles AJAX requests in the WordPress admin area.
 */
class Review_Wall_Ajax_Admin
{
    /**
     * Initializes admin AJAX handlers.
     */
    public static function init()
    {
        add_action('wp_ajax_review_wall_delete_review', [__CLASS__, 'delete_review']);
    }

    /**
     * Deletes a review from the database.
     */
    public static function delete_review()
    {
        // Permission check
        if (!current_user_can('manage_options')) {
            wp_send_json_error(['message' => 'Unauthorized']);
        }

        // Nonce check
        check_ajax_referer('review_wall_nonce', 'nonce');

        // Review ID
        $review_id = isset($_POST['review_id']) ? intval($_POST['review_id']) : 0;
        if (!$review_id) {
            wp_send_json_error(['message' => 'Invalid review ID']);
        }

        // Delete review
        $db = Review_Wall_Helper::get_db_instance();
        $deleted = $db->delete_google_review($review_id);

        if ($deleted) {
            // Remaining reviews
            $reviews = $db->get_google_reviews();

            $html = '';
            // If no reviews left but service is connected
            if (empty($reviews)) {
                ob_start();
                require REVIEWS_WALL_PATH . 'includes/views/empty-reviews.php';
                $html = ob_get_clean();
            }

            wp_send_json_success([
                'message'       => 'Review deleted',
                'empty_reviews' => $html,
                'reviews'       => count($reviews)
            ]);
        }

        wp_send_json_error(['message' => 'Failed to delete']);
    }
}
