(function ($) {
    'use strict';

    $(document).ready(function () {
        initGoogleReviewSlider();
        initReviewModalEvents();
    });

    /**
     * Initializes the Google Reviews Swiper slider.
     */
    function initGoogleReviewSlider() {
        // Ensure Swiper is available
        if (typeof Swiper === 'undefined') {
            console.error('Swiper is not loaded');
            return;
        }

        new Swiper('.rw-google-widget__swiper', {
            slidesPerView: 1,
            slidesPerGroup: 1,
            spaceBetween: 12,
            speed: 700,
            loop: false,
            navigation: {
                nextEl: '.rw-google-widget__arrow-next',
                prevEl: '.rw-google-widget__arrow-prev'
            },
            breakpoints: {
                576: {
                    slidesPerView: 2,
                    slidesPerGroup: 2,
                },
                768: {
                    slidesPerView: 3,
                    slidesPerGroup: 3,
                },
                992: {
                    slidesPerView: 4,
                    slidesPerGroup: 4,
                },
            }
        });
    }

    /**
     * Attach click events to open the review modal.
     * Uses data-* attributes directly from the button.
     */
    function initReviewModalEvents() {
        $(document).on('click', '.rw-google-card__read-more', function (e) {
            e.preventDefault();

            const $btn = $(this);

            const author = $btn.data('author');
            const rating = parseInt($btn.data('rating'));
            const content = $btn.data('content');
            const photo = $btn.data('photo');

            updateModalContent(author, rating, content, photo);
        });
    }

    /**
     * Update the existing modal with review content.
     * @param {string} author
     * @param {number} rating
     * @param {string} content
     * @param {string} photo
     */
    function updateModalContent(author, rating, content, photo) {
        const $modal = $('.rw-google-review-modal');

        if (!$modal.length) {
            console.error('Modal not found');
            return;
        }

        $modal.find('.rw-google-review').remove();

        const svgStarFull = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#FDBF01"/>
        </svg>`;

        const svgStarEmpty = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#C3C3C3"/>
        </svg>`;

        let starsHtml = '';
        for (let i = 0; i < 5; i++) {
            starsHtml += i < rating ? svgStarFull : svgStarEmpty;
        }

        const modalContent = `
            <div class="rw-google-review">
                <div class="rw-google-review__top">
                    ${photo ? `
                    <div class="rw-google-review__photo">
                        <img src="${photo}" alt="${author}">
                    </div>
                    ` : ''}
                    <p class="rw-google-review__author">${author}</p>
                </div>
                <div class="rw-google-review__item">
                    <div class="rw-google-review__rating">${starsHtml}</div>
                    <p class="rw-google-review__content">${content}</p>
                </div>
            </div>
        `;

        $modal.append(modalContent);
    }
})(jQuery);