<?php

/**
 * Admin template for global Google Reviews settings.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get global settings
$google_average_rating = get_option('review_wall_google_average_rating');
$google_total_reviews  = get_option('review_wall_google_total_reviews');
$google_reviews_link   = get_option('review_wall_google_reviews_link');

?>

<div class="review-wall-section">
    <h2><?php esc_html_e('Google Reviews Settings', 'review-wall'); ?></h2>

    <form method="post" action="" class="review-wall-form">
        <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
        <input type="hidden" name="review_wall_submit_action" value="save_google_reviews_settings">

        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="review_wall_google_average_rating"><?php esc_html_e('Average Rating', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="number" step="0.1" min="0" max="5" name="review_wall_google_average_rating" id="review_wall_google_average_rating"
                        value="<?php echo esc_attr($google_average_rating); ?>" class="regular-text" />
                    <p class="description">
                        <?php esc_html_e('The average rating shown in the widget (0.0–5.0).', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="review_wall_google_total_reviews"><?php esc_html_e('Total Reviews', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="number" min="0" name="review_wall_google_total_reviews" id="review_wall_google_total_reviews"
                        value="<?php echo esc_attr($google_total_reviews); ?>" class="regular-text" />
                    <p class="description">
                        <?php esc_html_e('Total number of Google reviews to display.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="review_wall_google_reviews_link"><?php esc_html_e('Google Reviews URL', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="url" name="review_wall_google_reviews_link" id="review_wall_google_reviews_link"
                        value="<?php echo esc_url($google_reviews_link); ?>" class="regular-text" />
                    <p class="description">
                        <?php esc_html_e('Link to your business’s Google reviews page.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
        </table>

        <?php submit_button(__('Save Settings', 'review-wall')); ?>
    </form>
</div>