<?php

/**
 * Text settings template.
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

// Define an array of setting keys
$settings_keys = [
    'review_wall_title_step_1',
    'review_wall_description_step_1',
    'review_wall_btn_step_1',
    'review_wall_title_step_2',
    'review_wall_description_step_2',
    'review_wall_comment_label',
    'review_wall_email_label',
    'review_wall_btn_step_2',
    'review_wall_title_step_3',
    'review_wall_btn_step_3',
];

// Load all settings into an associative array
$settings = [];
foreach ($settings_keys as $key) {
    $settings[$key] = get_option($key);
}

$steps = [
    [
        'title'       => __('Step 1 - Initial Rating Screen', 'review-wall'),
        'description' => __('Customize texts for the first screen where users rate their experience.', 'review-wall'),
        'fields' => [
            'review_wall_title_step_1'       => __('Title', 'review-wall'),
            'review_wall_description_step_1' => __('Description', 'review-wall'),
            'review_wall_btn_step_1'         => __('Button Text', 'review-wall'),
        ]
    ],
    [
        'title'       => __('Step 2 - Feedback Form (Negative Rating)', 'review-wall'),
        'description' => __('Customize texts for the second screen shown when a user gives a rating below the threshold.', 'review-wall'),
        'fields' => [
            'review_wall_title_step_2'       => __('Title', 'review-wall'),
            'review_wall_description_step_2' => __('Description', 'review-wall'),
            'review_wall_comment_label'      => __('Comment Field Label', 'review-wall'),
            'review_wall_email_label'        => __('Email Field Label', 'review-wall'),
            'review_wall_btn_step_2'         => __('Button Text', 'review-wall'),
        ]
    ],
    [
        'title'       => __('Step 3 - Thank You Screen', 'review-wall'),
        'description' => __('Customize texts for the final screen shown after submitting feedback.', 'review-wall'),
        'fields' => [
            'review_wall_title_step_3' => __('Title', 'review-wall'),
            'review_wall_btn_step_3'   => __('Button Text', 'review-wall'),
        ]
    ]
];

?>
<div class="review-wall-section">
    <h2><?php esc_html_e('Text Settings', 'review-wall'); ?></h2>

    <form method="post" action="" class="review-wall-form">
        <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
        <input type="hidden" name="review_wall_submit_action" value="save_text_settings">

        <?php foreach ($steps as $step) : ?>
            <div class="review-wall-card">
                <h3><?php echo esc_html($step['title']); ?></h3>
                <p class="description"><?php echo esc_html($step['description']); ?></p>

                <table class="form-table">
                    <?php foreach ($step['fields'] as $key => $label) : ?>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr($key); ?>">
                                    <?php echo esc_html($label); ?>
                                </label>
                            </th>
                            <td>
                                <?php if (strpos($key, 'description') !== false) : ?>
                                    <textarea name="<?php echo esc_attr($key); ?>" id="<?php echo esc_attr($key); ?>" class="large-text" rows="3" required><?php echo esc_textarea($settings[$key]); ?></textarea>
                                <?php else : ?>
                                    <input type="text" name="<?php echo esc_attr($key); ?>" id="<?php echo esc_attr($key); ?>" class="regular-text" value="<?php echo esc_attr($settings[$key]); ?>" required>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endforeach; ?>

        <p class="submit">
            <input type="submit" name="submit" class="button button-primary" value="<?php esc_html_e('Save Text Settings', 'review-wall'); ?>">
        </p>
    </form>
</div>