<?php

/**
 * Add new URL form template.
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="review-wall-section">
    <h2><?php esc_html_e('Add New URL', 'review-wall'); ?></h2>

    <form method="post" action="" class="review-wall-form">
        <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
        <input type="hidden" name="review_wall_submit_action" value="add_url">

        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="url_name"><?php esc_html_e('Name', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="text" name="url_name" id="url_name" class="regular-text" required>
                    <p class="description"><?php esc_html_e('Name for this URL.', 'review-wall'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="url_key"><?php esc_html_e('URL Key', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="text" name="url_key" id="url_key" class="regular-text" placeholder="<?php esc_html_e('Leave empty to auto-generate', 'review-wall'); ?>">
                    <?php /*<button type="button" class="button" id="generate_key_button"><?php esc_html_e('Generate Key', 'review-wall'); ?></button>*/ ?>
                    <p class="description"><?php esc_html_e('This key will be used in the URL parameter.', 'review-wall'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="url_link"><?php esc_html_e('Google Review URL', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="url" name="url_link" id="url_link" class="regular-text" required>
                    <p class="description"><?php esc_html_e('The URL to the Google Review page.', 'review-wall'); ?></p>
                </td>
            </tr>
        </table>

        <p class="submit">
            <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_html_e('Add URL', 'review-wall'); ?>">
        </p>
    </form>
</div>