<?php

defined('ABSPATH') || exit;

?>

<div class="review-wall-modal" id="delete-url-modal">
    <div class="review-wall-modal__content">
        <span class="review-wall-modal__close">&times;</span>
        <h2><?php esc_html_e('Delete URL', 'review-wall'); ?></h2>

        <p><?php esc_html_e('Are you sure you want to delete this URL? This action cannot be undone.', 'review-wall'); ?></p>

        <form class="review-wall-form" method="post" action="">
            <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
            <input type="hidden" name="review_wall_submit_action" value="delete_url">
            <input type="hidden" name="url_id" id="delete_url_id">

            <p class="submit">
                <input type="submit" name="submit" class="button button-primary" value="<?php esc_html_e('Delete', 'review-wall'); ?>">
                <button type="button" class="button cancel-delete"><?php esc_html_e('Cancel', 'review-wall'); ?></button>
            </p>
        </form>
    </div>
</div>