<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall
 *
 * The main class for initializing the Review Wall plugin.
 */
class Review_Wall
{
    /**
     * Initializes the plugin by loading necessary files, setting hooks, and initializing components.
     */
    public static function init()
    {
        // Include necessary files
        self::includes();

        Review_Wall_Admin::init();
        Review_Wall_Settings_Link::init();
        Review_Wall_Assets::init();
        Review_Wall_Page_Manager::init();

        // Only initialize frontend components if license is valid OR if we're in admin area
        if (Review_Wall_License::is_valid() || is_admin()) {
            Review_Wall_Post_Type::init();
            Review_Wall_Shortcode::init();
            Review_Wall_Ajax_Frontend::init();
            Review_Wall_Ajax_Admin::init();
        }

        if (Review_Wall_License::is_valid()) {
            Review_Wall_Google_Api::init();
        }

        // Initialize hooks and filters
        self::init_hooks();
    }

    /**
     * Includes necessary files for the plugin.
     */
    private static function includes()
    {
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-license.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-assets.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-post-type.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-admin.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-settings-link.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-shortcode.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-helper.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-form-handler.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-page-manager.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-ajax-frontend.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-ajax-admin.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-google-api.php';
        require_once REVIEWS_WALL_PATH . 'includes/classes/class-review-wall-settings.php';
    }

    /**
     * Initializes hook and filter methods.
     */
    private static function init_hooks()
    {
        add_filter('body_class', [__CLASS__, 'add_review_wall_body_class'], 99);
    }

    /**
     * Adds a custom class to the body tag on review wall pages.
     *
     * @param array $classes Array of body classes.
     * @return array Modified array of body classes.
     */
    public static function add_review_wall_body_class($classes)
    {
        if (Review_Wall_Page_Manager::is_review_wall_page() && Review_Wall_License::is_valid()) {
            $classes[] = 'review-wall-page';
        }
        return $classes;
    }
}
