<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Settings_Link
 *
 * Adds settings link to the plugins page.
 */
class Review_Wall_Settings_Link
{
    /**
     * Initializes the settings link functionality.
     */
    public static function init()
    {
        $plugin_basename = plugin_basename(REVIEWS_WALL_PATH) . '/review-wall.php';
        add_filter('plugin_action_links_' . $plugin_basename, [self::class, 'add_settings_link']);
    }

    /**
     * Adds a settings link to the plugins page.
     *
     * @param array $links Existing plugin action links.
     * @return array Modified plugin action links.
     */
    public static function add_settings_link($links)
    {
        $settings_link = '<a href="' . admin_url('admin.php?page=review-wall') . '">' . __('Settings', 'review-wall') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }
}
