<?php

defined('ABSPATH') || exit;

/**
 * Review_Wall_License
 *
 * Manages plugin license key storage and validation.
 */
class Review_Wall_License
{
    private const LICENSE_STATUS_KEY = 'review_wall_license_status';

    /**
     * Check license validity by API request
     * 
     * @param string $license_key
     * @return string 'valid', 'invalid' or 'error'
     */
    public static function check_license($license_key)
    {
        $response = wp_remote_post(REVIEW_WALL_API_URL . '/wp-json/wc-software-api/v1/check', [
            'timeout' => 15,
            'body'    => [
                'license_key' => $license_key,
                'site_url'    => home_url(),
            ],
        ]);

        if (is_wp_error($response)) {
            return 'error';
        }

        $data = json_decode(wp_remote_retrieve_body($response), true);

        if (!is_array($data)) {
            return 'error';
        }

        return (!empty($data['valid']) && $data['valid'] === true) ? 'valid' : 'invalid';
    }

    /**
     * Check if the license is currently valid
     * 
     * @return bool
     */
    public static function is_valid()
    {
        return get_option(self::LICENSE_STATUS_KEY) === 'valid';
    }
}
