<?php

defined('ABSPATH') || exit;

/**
 * Class Review_Wall_Assets
 *
 * This class handles the enqueueing of scripts and styles for both the frontend and admin interface of the Review Wall plugin.
 */
class Review_Wall_Assets
{
    /**
     * Initializes the hooks for enqueueing admin and frontend scripts and styles.
     */
    public static function init()
    {
        add_action('admin_enqueue_scripts', [self::class, 'enqueue_admin_scripts']);
        add_action('wp_enqueue_scripts', [self::class, 'enqueue_frontend_scripts']);
    }

    /**
     * Enqueues admin-specific styles and scripts.
     *
     * @param string $hook Current admin page hook.
     */
    public static function enqueue_admin_scripts($hook)
    {
        // Only load on the Review Wall admin page
        if (strpos($hook, 'review-wall') !== false) {
            // Enqueue the media uploader
            wp_enqueue_media();

            // WordPress Color Picker
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_script('wp-color-picker');

            // Enqueue admin styles
            wp_enqueue_style('swiper-css', REVIEWS_WALL_URL . 'assets/css/libs/swiper-bundle.min.css', [], REVIEW_WALL_VERSION);
            wp_enqueue_style('base-css', REVIEWS_WALL_URL . 'assets/css/admin/base.css', [], REVIEW_WALL_VERSION);
            wp_enqueue_style('dashboard-css', REVIEWS_WALL_URL . 'assets/css/admin/pages/dashboard.css', [], REVIEW_WALL_VERSION);
            wp_enqueue_style('google-reviews-css', REVIEWS_WALL_URL . 'assets/css/admin/pages/google-reviews.css', [], REVIEW_WALL_VERSION);

            // Enqueue admin scripts
            wp_enqueue_script(
                'swiper-js',
                REVIEWS_WALL_URL . 'assets/js/libs/swiper-bundle.min.js',
                [],
                REVIEW_WALL_VERSION,
                true
            );

            wp_enqueue_script(
                'review-wall-admin-common-js',
                REVIEWS_WALL_URL . 'assets/js/admin/admin-common.js',
                ['jquery'],
                REVIEW_WALL_VERSION,
                true
            );

            wp_enqueue_script(
                'review-wall-dashboard-js',
                REVIEWS_WALL_URL . 'assets/js/admin/pages/dashboard.js',
                ['jquery', 'review-wall-admin-common-js'],
                REVIEW_WALL_VERSION,
                true
            );

            wp_enqueue_script(
                'review-wall-google-reviews-js',
                REVIEWS_WALL_URL . 'assets/js/admin/pages/google-reviews.js',
                ['jquery', 'swiper-js', 'review-wall-admin-common-js'],
                REVIEW_WALL_VERSION,
                true
            );

            // Localize reviewWallParams into main JS file
            wp_localize_script('review-wall-admin-common-js', 'reviewWallParams', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce'    => wp_create_nonce('review_wall_nonce'),
            ]);
        }
    }

    /**
     * Enqueues frontend-specific styles and scripts.
     */
    public static function enqueue_frontend_scripts()
    {
        // Enqueue frontend styles
        wp_enqueue_style('swiper-css', REVIEWS_WALL_URL . 'assets/css/libs/swiper-bundle.min.css', [], REVIEW_WALL_VERSION);
        wp_enqueue_style('remodal-css', REVIEWS_WALL_URL . 'assets/css/libs/remodal.css', [], REVIEW_WALL_VERSION);
        wp_enqueue_style('remodal-default-theme-css', REVIEWS_WALL_URL . 'assets/css/libs/remodal-default-theme.css', [], REVIEW_WALL_VERSION);
        wp_enqueue_style('review-wall-page-css', REVIEWS_WALL_URL . 'assets/css/frontend/review-wall-page.css', [], REVIEW_WALL_VERSION);
        wp_enqueue_style('review-wall-google-widget-css', REVIEWS_WALL_URL . 'assets/css/frontend/review-wall-google-widget.css', [], REVIEW_WALL_VERSION);

        // Enqueue frontend scripts
        wp_enqueue_script(
            'swiper-js',
            REVIEWS_WALL_URL . 'assets/js/libs/swiper-bundle.min.js',
            [],
            REVIEW_WALL_VERSION,
            true
        );

        wp_enqueue_script(
            'remodal-js',
            REVIEWS_WALL_URL . 'assets/js/libs/remodal.min.js',
            [],
            REVIEW_WALL_VERSION,
            true
        );

        wp_enqueue_script(
            'review-wall-frontend-common-js',
            REVIEWS_WALL_URL . 'assets/js/frontend/frontend-common.js',
            ['jquery'],
            REVIEW_WALL_VERSION,
            true
        );

        wp_enqueue_script(
            'review-wall-page-js',
            REVIEWS_WALL_URL . 'assets/js/frontend/review-wall-page.js',
            ['jquery', 'review-wall-frontend-common-js'],
            REVIEW_WALL_VERSION,
            true
        );

        wp_enqueue_script(
            'review-wall-google-widget-js',
            REVIEWS_WALL_URL . 'assets/js/frontend/review-wall-google-widget.js',
            ['jquery', 'swiper-js', 'review-wall-frontend-common-js'],
            REVIEW_WALL_VERSION,
            true
        );

        // Localize reviewWallParams into main JS file
        wp_localize_script('review-wall-frontend-common-js', 'reviewWallParams', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('review_wall_nonce'),
        ]);
    }
}
