(function ($) {
    'use strict';

    $(document).ready(function () {
        initMediaUploader();
        initLogoRemoval();
        initKeyGenerator();
        initUrlEditing();
        initUrlDeletion();
        initModalHandling();
    });

    /**
     * Initialize the media uploader for logo selection
     */
    function initMediaUploader() {
        let imageFrame;

        $('#upload_logo_button').on('click', function (e) {
            e.preventDefault();

            if (imageFrame) {
                imageFrame.open();
                return;
            }

            imageFrame = wp.media({
                title: 'Select or Upload Logo',
                button: {
                    text: 'Use this logo'
                },
                multiple: false
            });

            imageFrame.on('select', function () {
                const attachment = imageFrame.state().get('selection').first().toJSON();
                $('#review_wall_logo').val(attachment.id);

                // Show loading spinner first
                $('#logo_preview').html('<div class="spinner is-active" style="float: none; margin: 0 0 10px 0;"></div>');

                // Create image element and add load event
                const img = new Image();

                img.onload = function () {
                    // Replace spinner with image when loaded
                    $('#logo_preview').html('<img src="' + attachment.url + '" style="max-width: 200px;">');
                };

                img.onerror = function () {
                    // Handle loading error
                    $('#logo_preview').html('<p class="error">Error loading image</p>');
                };

                // Start loading the image
                img.src = attachment.url;

                // Show remove button if it doesn't exist
                if ($('#remove_logo_button').length === 0) {
                    $('#upload_logo_button').after(' <button type="button" class="button" id="remove_logo_button">Remove Logo</button>');
                }
            });

            imageFrame.open();
        });
    }

    /**
     * Initialize the logo removal functionality
     */
    function initLogoRemoval() {
        $(document).on('click', '#remove_logo_button', function (e) {
            e.preventDefault();
            $('#review_wall_logo').val('');
            $('#logo_preview').html('');
            $(this).remove();
        });
    }

    /**
     * Initialize the key generation functionality
     */
    function initKeyGenerator() {
        $('#generate_key_button').on('click', function () {
            const randomKey = generateRandomKey(7);
            $('#url_key').val(randomKey);
        });
    }

    /**
     * Initialize the URL editing functionality
     */
    function initUrlEditing() {
        $('.edit-url').on('click', function (e) {
            e.preventDefault();

            const id = $(this).data('id');
            const name = $(this).data('name');
            const key = $(this).data('key');
            const url = $(this).data('url');

            $('#edit_url_id').val(id);
            $('#edit_url_name').val(name);
            $('#edit_url_key').val(key);
            $('#edit_url_link').val(url);

            $('#edit-url-modal').show();
        });
    }

    /**
     * Initialize the URL deletion functionality
     */
    function initUrlDeletion() {
        $('.delete-url').on('click', function (e) {
            e.preventDefault();

            const id = $(this).data('id');
            $('#delete_url_id').val(id);

            $('#delete-url-modal').show();
        });
    }

    /**
     * Initialize modal dialog handling
     */
    function initModalHandling() {
        // Close modals with close button or cancel button
        $('.review-wall-modal-close, .cancel-delete').on('click', function () {
            $('.review-wall-modal').hide();
        });

        // Close modal when clicking outside
        $(window).on('click', function (e) {
            if ($(e.target).hasClass('review-wall-modal')) {
                $('.review-wall-modal').hide();
            }
        });
    }

    /**
     * Generates a random key with specified length.
     *
     * @param {number} length The length of the key.
     * @return {string} A random key.
     */
    function generateRandomKey(length) {
        let result = '';
        const characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
        const charactersLength = characters.length;

        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }
})(jQuery);