<?php
/**
 * Handles plugin getting started page.
 * 
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once( DSRBFW_PLUGIN_HEADER_LINK ); // phpcs:ignore
?>
<div class="dsrbfw-section-left">
	<div class="dsrbfw-main-table res-cl">
		<h2><?php esc_html_e( 'Getting Started', 'revenue-booster-for-woocommerce' ); ?></h2>
		<table class="table-outer getting-started-section">
			<tbody>
				<tr>
					<td class="fr-2">
						<p class="block textgetting"><?php esc_html_e( 'The "Frequently bought together" is a strategy that suggests products that are often purchased together by customers.', 'revenue-booster-for-woocommerce' ); ?></p>
						<p class="block textgetting"><?php esc_html_e( 'It\'s used by online and brick-and-mortar stores to help customers discover complementary products that can add value to their purchases.', 'revenue-booster-for-woocommerce' ); ?></p>
						<p class="block textgetting"><?php esc_html_e( 'Here are the step-by-step guides to configure the settings.', 'revenue-booster-for-woocommerce' ); ?></p>
                        <p class="block textgetting"><strong><?php esc_html_e( 'Step 1', 'revenue-booster-for-woocommerce' ); ?>:</strong> <?php esc_html_e( 'Go to the product edit page where you need to configure the Post-Cart Frequently Bought Together products.', 'revenue-booster-for-woocommerce' ); ?></p>
                        <p class="block textgetting">
                            <strong><?php esc_html_e( 'Step 2', 'revenue-booster-for-woocommerce' ); ?>:</strong> <?php esc_html_e( 'Go to the Revenue Booster Tab under the Product data box.', 'revenue-booster-for-woocommerce' ); ?>
                            <span class="gettingstarted">
                                <img src="<?php echo esc_url( DSRBFW_PLUGIN_URL ) . 'admin/images/getting-started/screenshot-1.png'; ?>">
                            </span>
                        </p>
                        <p class="block textgetting">
                            <strong><?php esc_html_e( 'Step 3', 'revenue-booster-for-woocommerce' ); ?>:</strong> <?php esc_html_e( 'Select the products that you want to allow to purchase in the popup as Post-Cart Frequently Bought Together, once the user adds this product to the cart.', 'revenue-booster-for-woocommerce' ); ?>
                            <span class="gettingstarted">
                                <img src="<?php echo esc_url( DSRBFW_PLUGIN_URL ) . 'admin/images/getting-started/screenshot-2.png'; ?>">
                            </span>
                        </p>
                        <p class="block textgetting">
                            <strong><?php esc_html_e( 'Step 4', 'revenue-booster-for-woocommerce' ); ?>:</strong> <?php esc_html_e( 'Once the user adds the product to the cart it will open the popup that recommended other products in the popup like below.', 'revenue-booster-for-woocommerce' ); ?>
                            <span class="gettingstarted">
                                <img src="<?php echo esc_url( DSRBFW_PLUGIN_URL ) . 'admin/images/getting-started/screenshot-3.png'; ?>">
                            </span>
                        </p>
                        <p class="block textgetting">
                            <strong><?php esc_html_e( 'Step 5', 'revenue-booster-for-woocommerce' ); ?>:</strong> <?php esc_html_e( 'Once the user adds any of the products it will add to the order list as you can see in the below screen.', 'revenue-booster-for-woocommerce' ); ?>
                            <span class="gettingstarted">
                                <img src="<?php echo esc_url( DSRBFW_PLUGIN_URL ) . 'admin/images/getting-started/screenshot-4.png'; ?>">
                            </span>
                        </p>
                    </td>
                </tr>
			</tbody>
		</table>
	</div>
</div>
<?php
require_once( DSRBFW_PLUGIN_FOOTER_LINK ); // phpcs:ignore