jQuery(document).ready(function ($) {
  // Handle Install Now clicks
  $(".rvm-install-link").on("click", function (e) {
    const $link = $(this);
    const isInstalled = $link.data("installed") === true;
    const slug = $link.data("slug");
    const version = $link.data("version");
    const type = $link.data("type") || "plugin";

    if (isInstalled) {
      e.preventDefault();

      // Create dialog
      const dialog = $(`
              <div class="rvm-confirm-dialog">
                  <div class="rvm-confirm-dialog-content">
                      <h3>${wp.i18n.__(
                        type === "theme"
                          ? "Theme Already Installed"
                          : "Plugin Already Installed",
                        "retro-version-manager"
                      )}</h3>
                      <p>${wp.i18n.__(
                        "The",
                        "retro-version-manager"
                      )} ${type} <strong>${slug}</strong> ${wp.i18n.__(
        "is already installed. Please deactivate and delete it manually from the",
        "retro-version-manager"
      )} ${type === "theme" ? "Themes" : "Plugins"} ${wp.i18n.__(
        "page before installing version",
        "retro-version-manager"
      )} <strong>${version}</strong>.</p>
                      <div class="rvm-confirm-dialog-buttons">
                          <button class="rvm-confirm">${wp.i18n.__(
                            type === "theme" ? "Go to Themes" : "Go to Plugins",
                            "retro-version-manager"
                          )}</button>
                          <button class="rvm-cancel">${wp.i18n.__(
                            "Cancel",
                            "retro-version-manager"
                          )}</button>
                      </div>
                  </div>
              </div>
          `);

      // Append dialog to body and show
      $("body").append(dialog);
      dialog.show();

      // Handle confirm
      dialog.find(".rvm-confirm").on("click", function () {
        window.location.href =
          type === "theme"
            ? retrvema_admin.themes_url
            : retrvema_admin.plugins_url;
      });

      // Handle cancel
      dialog.find(".rvm-cancel").on("click", function () {
        dialog.remove();
      });
    }
  });
});
