<?php

/**
 * Plugin Name: Restore Classic Editor & Widgets – Clean & Lightweight Dashboard
 * Plugin URI: https://joker-studio.fr/restore-classic-editor-widgets-dashboard-cleaner/
 * Description: Restore the classic editor and widgets, block dashboard ads, and optimize performance for a faster WordPress admin.
 * Version: 1.5
 * Author: Joker Studio
 * Author URI: https://joker-studio.fr
 * License: GPL2
 * Text Domain: restore-classic-editor-widgets-dashboard-cleaner
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('RESTCLED_PLUGIN_DIR', plugin_dir_path(__FILE__));

// Définir la constante principale
define('RESTCLED_PLUGIN_FILE', __FILE__);

// Charger les traductions au bon moment
function restcled_load_textdomain() {
    $lang_dir = plugin_dir_path(__FILE__) . 'languages/';
    $locale = get_locale();
    $mo_file = $lang_dir . 'restore-classic-editor-widgets-dashboard-cleaner-' . $locale . '.mo';

    if (file_exists($mo_file)) {
        load_textdomain('restore-classic-editor-widgets-dashboard-cleaner', $mo_file);
    }
}
add_action('init', 'restcled_load_textdomain');

// Add settings page to admin menu
function restcled_add_admin_menu() {
    add_options_page(
        esc_html__('Classic Editor & Widgets Settings', 'restore-classic-editor-widgets-dashboard-cleaner'),
        esc_html__('Classic Editor & Widgets', 'restore-classic-editor-widgets-dashboard-cleaner'),
        'manage_options',
        'restcled_settings',
        'restcled_settings_page'
    );
}
add_action('admin_menu', 'restcled_add_admin_menu');

function restcled_plugin_action_links($links) {
    $settings_link = '<a href="options-general.php?page=restcled_settings">' . esc_html__('Settings', 'restore-classic-editor-widgets-dashboard-cleaner') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'restcled_plugin_action_links');

// Register plugin settings
function restcled_register_settings() {
    register_setting('restcled_settings_group', 'restcled_classic_editor', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_classic_widgets', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_block_ads', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_hide_wp_info', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_optimize_dashboard', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_enable_footer_customization', 'restcled_sanitize_checkbox');
    register_setting('restcled_settings_group', 'restcled_footer_text', 'sanitize_text_field');
}
add_action('admin_init', 'restcled_register_settings');

// Sanitize checkbox input
function restcled_sanitize_checkbox($input) {
    return (isset($input) && $input == 1) ? 1 : 0;
}

// Disable Gutenberg
if (get_option('restcled_classic_editor', 1)) {
    add_filter('use_block_editor_for_post', '__return_false');
    add_filter('use_block_editor_for_post_type', '__return_false');
}

// Restore classic widgets
if (get_option('restcled_classic_widgets', 1)) {
    add_filter('use_widgets_block_editor', '__return_false');
}

// Block admin dashboard ads
if (get_option('restcled_block_ads', 1)) {
    function restcled_remove_admin_ads() {
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
    }
    add_action('admin_init', 'restcled_remove_admin_ads', 999);
}

// Hide WordPress version info
if (get_option('restcled_hide_wp_info', 0)) {
    function restcled_remove_wp_version() {
        return '';
    }
    add_filter('the_generator', 'restcled_remove_wp_version');
    remove_action('wp_head', 'wp_generator');
}

// Optimize dashboard widgets
if (get_option('restcled_optimize_dashboard', 1)) {
    function restcled_optimize_dashboard() {
        remove_action('wp_dashboard_setup', 'wp_dashboard_widgets');
        add_action('admin_init', function() {
            remove_action('welcome_panel', 'wp_welcome_panel');
        });
    }
    add_action('admin_init', 'restcled_optimize_dashboard');
}

// Inject custom footer
function restcled_custom_footer() {
    if (get_option('restcled_enable_footer_customization', 0)) {
        $footer_raw = get_option('restcled_footer_text', '© ' . gmdate('Y') . ' - ' . __('Developed by Joker Studio', 'restore-classic-editor-widgets-dashboard-cleaner'));
        $footer_text = wp_kses_post($footer_raw);
        $dir = is_rtl() ? 'rtl' : 'ltr';
        echo '<div id="restcled-footer" style="direction: ' . esc_attr($dir) . '; text-align: center; padding: 10px 0; width: 100%; font-size: 14px;">' . wp_kses_post($footer_text) . '</div>';
    }
}
add_action('wp_footer', 'restcled_custom_footer', 999);

// Settings page output
function restcled_settings_page() {
    $margin = is_rtl() ? 'margin-right' : 'margin-left';
?>
<div class="wrap">
<h1><?php echo esc_html__('Classic Editor & Widgets Settings', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></h1>
<form method="post" action="options.php">
<?php settings_fields('restcled_settings_group'); ?>
<?php do_settings_sections('restcled_settings_group'); ?>
<table class="form-table">
<tr>
<th scope="row"><?php echo esc_html__('Enable Classic Editor', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_classic_editor" value="1" <?php checked(1, get_option('restcled_classic_editor', 1)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Disable Gutenberg and restore the classic editor interface for posts and pages.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Enable Classic Widgets', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_classic_widgets" value="1" <?php checked(1, get_option('restcled_classic_widgets', 1)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Use the old widget system instead of the new block-based one.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Block Dashboard Ads', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_block_ads" value="1" <?php checked(1, get_option('restcled_block_ads', 1)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Hide promotional banners and notifications injected by some plugins in the admin area.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Hide WordPress Info', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_hide_wp_info" value="1" <?php checked(1, get_option('restcled_hide_wp_info', 0)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Remove the WordPress version number from your site\'s source code for better privacy.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Optimize Dashboard', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_optimize_dashboard" value="1" <?php checked(1, get_option('restcled_optimize_dashboard', 1)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Remove unnecessary widgets and panels to speed up the admin dashboard.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Enable Custom Footer Text', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <label><input type="checkbox" name="restcled_enable_footer_customization" value="1" <?php checked(1, get_option('restcled_enable_footer_customization', 0)); ?>> <span style="<?php echo esc_attr($margin); ?>: 8px;"><?php echo esc_html__('Allow a custom message to appear in the footer of your public site.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></span></label>
</td>
</tr>
<tr>
<th scope="row"><?php echo esc_html__('Footer Text', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></th>
<td>
    <input type="text" name="restcled_footer_text" value="<?php echo esc_attr(get_option('restcled_footer_text', '© ' . gmdate('Y') . ' - Developed by Joker Studio')); ?>" style="width: 100%;">
    <p class="description"><?php echo esc_html__('Enter the message you want to display in the footer. HTML is allowed.', 'restore-classic-editor-widgets-dashboard-cleaner'); ?></p>
</td>
</tr>
</table>
<?php submit_button(); ?>
</form>
</div>
<?php
}
?>
