<?php
/**
 * Uninstall script for Restock Notifier For WooCommerce
 *
 * Deletes custom database table and plugin options when plugin is deleted via WordPress admin.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

global $wpdb;

$table_name = esc_sql( $wpdb->prefix . 'restocknotifierpcprajapat_subscribers' );

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Safe use in uninstall script, no caching or prepare needed for DROP TABLE.
$wpdb->query( "DROP TABLE IF EXISTS {$table_name}" );

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Deleting plugin options with prefix 'restocknotifierpcprajapat_'.
$wpdb->query( "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'restocknotifierpcprajapat_%'" );
