<?php
/**
 * Template: Stock Alert Form
 *
 * This template renders the email subscription form for out-of-stock WooCommerce products.
 * Can be overridden by placing a copy in yourtheme/restock-notifier-for-woocommerce/form-out-of-stock.php.
 *
 * @package Restock_Notifier_For_Woocommerce
 * @subpackage Templates
 * @version 1.0.0
 */


defined( 'ABSPATH' ) || exit;

global $product;
?>
<div class="restocknotifierpcprajapat_front_subscriber_form" id="restocknotifierpcprajapat_front_subscriber_form">
	<form method="post" class="restocknotifierpcprajapat-stock-alert-form">
	<?php wp_nonce_field( 'restocknotifierpcprajapat_subscribe_action', 'restocknotifierpcprajapat_nonce' ); ?>
		<div class="flex items-center">
			<svg class="w-5 h-5 text-yellow-500 mr-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
				<path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2h-1V9a1 1 0 00-1-1z" clip-rule="evenodd"></path>
			</svg>
			<span class="font-medium" id="form-heading"><?php esc_html_e( 'Out of Stock', 'restock-notifier-for-woocommerce' ); ?></span>
		</div>
		<p class="text-sm mb-3"><?php esc_html_e( 'Get notified when this product is back in stock:', 'restock-notifier-for-woocommerce' ); ?></p>
		<input type="hidden" name="restocknotifierpcprajapat_product_id" id="restocknotifierpcprajapat_product_id_input" value="<?php echo esc_attr( $product->get_id() ); ?>" />
		<div class="flex">
			<input type="email" name="restocknotifierpcprajapat_email" class="restocknotifierpcprajapat_email_field px-3 py-2" placeholder="<?php esc_attr_e( 'Your email address', 'restock-notifier-for-woocommerce' ); ?>" class="flex-1 border preview_email_field border-gray-300 px-3 py-2">
			<button type="submit" name="restocknotifierpcprajapat_submit" class="px-4 py-2 font-medium notify-btn" id="preview-button"><?php esc_html_e( 'Notify Me', 'restock-notifier-for-woocommerce' ); ?></button>
		</div>
	</form>
</div>
