<?php
/**
 * Database Handler for Restock Notifier For WooCommerce
 *
 * Creates the required database table for storing subscriber data upon plugin activation.
 *
 * @package Restock_Notifier_For_Woocommerce
 * @subpackage Database
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

class Restock_Notifier_For_Woocommerce_DB {

	public static function create_table() {
		global $wpdb;

		$table_name      = $wpdb->prefix . 'restocknotifierpcprajapat_subscribers';
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $table_name (
             id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
             product_id BIGINT(20) NOT NULL,
             email VARCHAR(255) NOT NULL,
             notified TINYINT(1) DEFAULT 0,
			 notified_at DATETIME NULL,
             date_added DATETIME DEFAULT CURRENT_TIMESTAMP,
             PRIMARY KEY (id)
         ) $charset_collate;";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $sql );
	}
}
