<?php
defined( 'ABSPATH' ) || exit;

$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
?>
<!-- Tabs -->
<div class="flex flex-wrap mb-6 gap-1">
	<button id="general-tab"
	class="tab-active px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
	<span class="dashicons dashicons-admin-generic mr-2"></span>
	<?php echo esc_html__( 'General', 'restock-notifier-for-woocommerce' ); ?>
	</button>
	<button id="email-tab"
	class="tab-inactive px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
	<span class="dashicons dashicons-email mr-2"></span>
	<?php echo esc_html__( 'Email Template', 'restock-notifier-for-woocommerce' ); ?>
	</button>
	<button id="subscribers-tab"
	class="tab-inactive px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
	<span class="dashicons dashicons-groups mr-2"></span>
	<?php echo esc_html__( 'Subscribers', 'restock-notifier-for-woocommerce' ); ?>
	</button>
	<button id="design-tab"
	class="tab-inactive px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
	<span class="dashicons dashicons-admin-customizer mr-2"></span>
	<?php echo esc_html__( 'Design', 'restock-notifier-for-woocommerce' ); ?>
	</button>
	<button id="advanced-tab"
	class="tab-inactive px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
	<span class="dashicons dashicons-admin-tools mr-2"></span>
	<?php echo esc_html__( 'Advanced', 'restock-notifier-for-woocommerce' ); ?>
	</button>
	<?php
	if ( isset( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			?>
					<button id="logs-tab" class="tab-inactive px-5 py-3 text-[16px] tracking-wider rounded-t-lg font-medium flex items-center transition-all duration-300">
					<span class="dashicons dashicons-admin-tools mr-2"></span>
					<?php echo esc_html__( 'Logs', 'restock-notifier-for-woocommerce' ); ?>
					</button>
				<?php
		}
	}
	?>
</div>
