<?php
defined( 'ABSPATH' ) || exit;
?>
<!-- Subscribers Tab -->
<div id="subscribers" class="tab-pane hidden">
	<div class="bg-white rounded-lg shadow-card overflow-hidden">
		<div class="gradient-header border-b border-gray-200 px-6 py-4">
			<h3 class="text-lg font-semibold flex items-center text-gray-800">
				<span class="dashicons dashicons-groups mr-2 text-primary-600"></span>
				<?php echo esc_html__( 'Subscribers Management', 'restock-notifier-for-woocommerce' ); ?>
			</h3>
		</div>	
		<div class="p-6">
			<div id="restocknotifierpcprajapat_subscribers_data">
				<div class="flex flex-wrap justify-between mb-6 items-center">
					<div>
						<button type="button" id="export_csv"
							class="px-4 py-3 pt-3.5 pb-2.5 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-all duration-300 shadow-sm flex items-center">
							<span class="dashicons dashicons-arrow-down-alt mr-2 text-primary-600"></span>
							<?php echo esc_html__( 'Export CSV', 'restock-notifier-for-woocommerce' ); ?>
						</button>
					</div>
					<div class="flex items-center">
						<label for="ssnfw-per-page" class="mr-2 text-sm text-gray-700"><?php echo esc_html__( 'Items per page:', 'restock-notifier-for-woocommerce' ); ?></label>
						<select id="ssnfw-per-page" class="!w-20 border border-gray-300 rounded px-2 py-1 text-sm">
							<option value="5">5</option>
							<option value="10" selected>10</option>
							<option value="25">25</option>
							<option value="50">50</option>
						</select>
					</div>
					<div class="flex items-center text-sm">
						<span class="mr-4 text-gray-600"><strong id="ssnfw-total-items">1</strong> <?php echo esc_html__( 'items', 'restock-notifier-for-woocommerce' ); ?></span>
						<div class="flex shadow-sm rounded-lg overflow-hidden">
							<button id="pag-first" class="px-3 border border-gray-300 rounded-tl-lg rounded-bl-lg bg-gray-100 text-gray-400">«</button>
							<button id="pag-prev"
								class="px-3 border-t border-b border-gray-300 bg-gray-100 text-gray-400">‹</button>
							<div class="px-3 border-t border-b border-gray-300 flex items-center bg-white">
								<input type="text" id="pag-input" value="1" class="w-10 text-center border border-gray-300 rounded-sm">
								<span class="ml-1 text-gray-600" id="pag-total"><?php echo esc_html__( 'of', 'restock-notifier-for-woocommerce' ); ?> 2</span>
							</div>
							<button id="pag-next"
								class="px-3 border-t border-b border-gray-300 bg-gray-100 hover:bg-gray-50 text-gray-700">›</button>
							<button id="pag-last" class="px-3 border border-gray-300 bg-gray-100 rounded-tr-lg rounded-br-lg hover:bg-gray-50 text-gray-700">»</button>
						</div>
					</div>
				</div>
				<div class="overflow-x-auto">
					<table class="min-w-full divide-y divide-gray-200 rounded-lg overflow-hidden">
						<thead>
							<tr>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<input type="checkbox"
										class="rounded border-gray-300 text-primary-600 focus:ring-primary-500">
								</th>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<?php echo esc_html__( 'Email', 'restock-notifier-for-woocommerce' ); ?></th>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<?php echo esc_html__( 'Product', 'restock-notifier-for-woocommerce' ); ?></th>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<?php echo esc_html__( 'Subscribed On', 'restock-notifier-for-woocommerce' ); ?></th>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<?php echo esc_html__( 'Status', 'restock-notifier-for-woocommerce' ); ?></th>
								<th scope="col"
									class="px-4 py-3 bg-gradient-to-r from-gray-50 to-gray-100 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
									<?php echo esc_html__( 'Actions', 'restock-notifier-for-woocommerce' ); ?></th>
							</tr>
						</thead>
						<tbody class="bg-white divide-y divide-gray-200">
						
						</tbody>
					</table>
				</div>
				<div class="flex flex-wrap justify-between mt-6">
					<div>
						<div class="flex items-center">
							<select id="restocknotifierpcprajapatbulk-selector"
								class="border w-40 border-gray-300 rounded-lg px-3 mr-2 focus:ring-primary-500 focus:border-primary-500">
								<option value="-1"><?php echo esc_html__( 'Bulk Actions', 'restock-notifier-for-woocommerce' ); ?></option>
								<option value="delete"><?php echo esc_html__( 'Delete', 'restock-notifier-for-woocommerce' ); ?></option>
							</select>
							<button type="button"
								class="restocknotifierpcprajapataaply_btn px-6 py-3 gradient-primary text-white rounded-lg hover:bg-gray-50 transition-all duration-300 shadow-sm"><?php echo esc_html__( 'Apply', 'restock-notifier-for-woocommerce' ); ?></button>
						</div>
					</div>
				</div>
			</div>
			<div id="ssnfw-subscribers-empty">
				<div class="px-6 py-12 text-center bg-white">
					<div class="flex flex-col items-center justify-center space-y-3">
						<div class="text-4xl text-primary-600">📭</div>
						<h4 class="text-lg font-semibold text-gray-800">
							<?php esc_html_e( 'No subscribers found.', 'restock-notifier-for-woocommerce' ); ?>
						</h4>
						<p class="text-gray-500 text-sm">
							<?php esc_html_e( 'Once someone subscribes to a product, their information will appear here.', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
