<?php
defined( 'ABSPATH' ) || exit;
?>
<!-- Logs Tab -->
<div id="logs" class="tab-pane ssnfw-tab-panel" data-tab="logs">
	<div class="bg-white rounded-lg shadow-card overflow-hidden">
		<div class="gradient-header border-b border-gray-200 px-6 py-4">
			<h3 class="text-lg font-semibold flex items-center text-gray-800">
				<span class="dashicons dashicons-media-default mr-2 text-primary-600"></span>
				<?php esc_html_e( 'Debug Logs', 'restock-notifier-for-woocommerce' ); ?>
			</h3>
		</div>
		<div class="p-6">
			<textarea readonly rows="20" class="w-full text-sm font-mono bg-gray-100 border border-gray-300 rounded-lg px-4 py-3 leading-relaxed"><?php echo esc_textarea( Restock_Notifier_For_Woocommerce_Logger::get_log_contents() ); ?>
			</textarea>

			<form method="post" style="margin-top: 10px;">
				<?php wp_nonce_field( 'restocknotifierpcprajapat_clear_logs_action', 'restocknotifierpcprajapat_clear_logs_nonce' ); ?>
				<input type="hidden" name="restocknotifierpcprajapat_clear_logs" value="1">
				<input type="submit" name="restocknotifierpcprajapat_clear_logs" id="restocknotifierpcprajapat_clear_logs_btn" class="px-6 py-2.5 rounded-lg cursor-pointer gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300" value="<?php esc_html_e( 'Clear Logs', 'restock-notifier-for-woocommerce' ); ?>">
			</form>
		</div>
	</div>
</div>
