<?php
// includes/admin/views/tab-general.php
defined( 'ABSPATH' ) || exit;
?>
<div id="general" class="tab-pane ssnfw-tab-panel" data-tab="general">
	<form method="post" action="options.php">
	<?php
		settings_fields( 'restocknotifierpcprajapat_general' );
		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
	?>
	<div class="bg-white rounded-lg shadow-card overflow-hidden">
		<div class="gradient-header border-b border-gray-200 px-6 py-4">
		<h3 class="text-lg font-semibold flex items-center text-gray-800">
			<span class="dashicons dashicons-admin-generic mr-2 text-primary-600"></span>
			<?php echo esc_html__( 'General Settings', 'restock-notifier-for-woocommerce' ); ?>
		</h3>
		</div>
		<div class="p-6 space-y-6">
		<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
			<div class="md:col-span-2">
			<label for="restocknotifierpcprajapat_enable_plugin" class="block font-medium text-gray-700">
				<?php echo esc_html__( 'Enable Plugin', 'restock-notifier-for-woocommerce' ); ?>
			</label>
			<p class="text-gray-500 text-sm mt-1">
				<?php echo esc_html__( 'Enable or disable the stock notification functionality.', 'restock-notifier-for-woocommerce' ); ?>
			</p>
			</div>
			<div class="md:col-span-3">
			<label class="relative inline-flex items-center cursor-pointer">
				<input type="hidden" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_plugin]" value="0" />
				<input type="checkbox" id="restocknotifierpcprajapat_enable_plugin" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_plugin]" class="sr-only peer" value="1"
					<?php checked( $settings['restocknotifierpcprajapat_enable_plugin'] ?? '', 1 ); ?> />
				<div
					class="relative w-14 h-7 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:start-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 dark:peer-checked:bg-blue-600">
				</div>
			</label>
			</div>
		</div>

		<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
			<div class="md:col-span-2">
			<label for="restocknotifierpcprajapat_display_form_after" class="block font-medium text-gray-700">
				<?php echo esc_html__( 'Display Form After', 'restock-notifier-for-woocommerce' ); ?>
			</label>
			<p class="text-gray-500 text-sm mt-1">
				<?php echo esc_html__( 'Choose where to display the notification form on product pages.', 'restock-notifier-for-woocommerce' ); ?>
			</p>
			</div>
			<div class="md:col-span-3">
				<?php $display = $settings['restocknotifierpcprajapat_display_form_after'] ?? 'price'; ?>
				<select name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_display_form_after]" id="restocknotifierpcprajapat_display_form_after" class="w-full md:w-64 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					<option value="after_title" <?php selected( $display, 'after_title' ); ?>><?php esc_html_e( 'After Title', 'restock-notifier-for-woocommerce' ); ?></option>
					<option value="after_price" <?php selected( $display, 'after_price' ); ?>><?php esc_html_e( 'After Price', 'restock-notifier-for-woocommerce' ); ?></option>
					<option value="after_description" <?php selected( $display, 'after_description' ); ?>><?php esc_html_e( 'After Description', 'restock-notifier-for-woocommerce' ); ?></option>
					<option value="shortcode" <?php selected( $display, 'shortcode' ); ?>><?php esc_html_e( 'Shortcode (Manual Placement)', 'restock-notifier-for-woocommerce' ); ?></option>
				</select>
			</div>
		</div>

		<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start <?php echo esc_attr( 'shortcode' === $display ? '' : 'hidden' ); ?>" id="shortcode_row">
			<div class="md:col-span-2">
			<label for="shortcode_name" class="block font-medium text-gray-700">
				<?php echo esc_html__( 'Shortcode', 'restock-notifier-for-woocommerce' ); ?>
			</label>
			<p class="text-gray-500 text-sm mt-1">
				<?php echo esc_html__( 'Use this shortcode where you want to display the form.', 'restock-notifier-for-woocommerce' ); ?>
			</p>
			</div>
			<div class="md:col-span-3">
				<div class="flex items-center space-x-3">
					<code id="restocknotifierpcprajapat-shortcode" class="bg-gray-100 text-gray-800 mr-0 px-4 py-2 rounded-tl-lg rounded-bl-lg font-mono text-sm border border-gray-300">
					[restock-notifier-for-woocommerce]
					</code>
					<button type="button" id="copy-shortcode" class="px-3 py-[9px] gradient-primary text-white text-sm font-medium rounded-tr-lg rounded-br-lg shadow-md hover:bg-primary-600 transition" aria-label="<?php esc_attr_e( 'Copy shortcode', 'restock-notifier-for-woocommerce' ); ?>" title="<?php esc_attr_e( 'Copy', 'restock-notifier-for-woocommerce' ); ?>">
						<span class="dashicons dashicons-admin-page"></span>
					</button>
				</div>
			</div>
		</div>
		<div class="pt-4 border-t border-gray-200">
			<button type="submit" class="px-6 py-2.5 rounded-lg gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300">
			<?php echo esc_html__( 'Save Changes', 'restock-notifier-for-woocommerce' ); ?>
			</button>
		</div>
		</div>
	</div>
	</form>
</div>
