<?php
// includes/admin/views/tab-email.php
defined( 'ABSPATH' ) || exit;
?>
<div id="email" class="tab-pane hidden">
	<form method="post" action="options.php">
		<?php
			settings_fields( 'restocknotifierpcprajapat_email_template' );
			$settings                    = get_option( 'restocknotifierpcprajapat_settings', array() );
			$default_email_body_stock_in = wpautop(
				sprintf(
					'<table width="100%%" cellpadding="0" cellspacing="0" style="background-color: #f0f4f8; padding: 40px 0;">
						<tr><td align="center">
							<table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 12px; box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12); overflow: hidden;">
								<tr>
									<td style="background: linear-gradient(135deg, #3b82f6, #2563eb); padding: 35px 40px; color: #fff;">
										<h1 style="margin: 0; font-size: 28px; font-weight: 700; color:#ffffff;">%s</h1>
									</td>
								</tr>
								<tr>
									<td align="center" style="padding: 40px 40px 20px;">
										<h2 style="margin: 0; font-size: 24px; font-weight: 600; color: #1a202c;">%s <span style="color: #3b82f6;">%%product_name%%</span></h2>
									</td>
								</tr>
								<tr>
									<td style="padding: 0 40px;">
										<p style="font-size: 17px; line-height: 28px; color: #4a5568;">%s</p>
									</td>
								</tr>
								<tr>
									<td style="padding: 30px 40px;">
										<table width="100%%" cellpadding="0" cellspacing="0" style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
											<tr>
												<td style="padding: 25px;">
													<table width="100%%" cellpadding="0" cellspacing="0">
														<tr>
															<td width="160" style="vertical-align: top;">
																%%product_image%%
															</td>
															<td style="vertical-align: top; padding-left: 20px;">
																<h3 style="margin: 0 0 10px; font-size: 20px; color: #1a202c;">%%product_name%%</h3>
																<p style="margin: 0 0 20px; font-size: 15px; line-height: 24px; color: #4a5568;">%%product_description%%</p>
																<a href="%%product_link%%" style="display: inline-block; background: linear-gradient(to right, #3b82f6, #2563eb); color: #fff; font-size: 15px; font-weight: 600; text-decoration: none; padding: 12px 24px; border-radius: 6px;">%s</a>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td style="padding: 30px 40px; background-color: #f8fafc; border-top: 1px solid #e2e8f0; text-align: center;">
										<p style="font-size: 15px; color: #4a5568;">%s<br><span style="color: #3b82f6; font-weight: 600;">%s</span></p>
									</td>
								</tr>
							</table>
						</td></tr>
					</table>',
					esc_html__( 'Restock Notifier For WooCommerce', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'Good news! Back in stock:', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'The product you subscribed for is now available. Grab it before it goes out of stock again!', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'View Product', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'Thank you for your patience.', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'The Team', 'restock-notifier-for-woocommerce' )
				)
			);

			$default_email_body = wpautop(
				sprintf(
					'<table width="100%%" cellpadding="0" cellspacing="0" style="background-color: #f0f4f8; padding: 40px 0;">
						<tr><td align="center">
							<table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 12px; box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12); overflow: hidden;">
								<tr>
									<td style="background: linear-gradient(135deg, #3b82f6, #2563eb); padding: 35px 40px; color: #fff;">
										<h1 style="margin: 0; font-size: 28px; font-weight: 700; color:#ffffff;">%s</h1>
									</td>
								</tr>
								<tr>
									<td align="center" style="padding: 40px 40px 20px;">
										<h2 style="margin: 0; font-size: 24px; font-weight: 600; color: #1a202c;">%s <span style="color: #3b82f6;">%%product_name%%</span></h2>
									</td>
								</tr>
								<tr>
									<td style="padding: 0 40px;">
										<p style="font-size: 17px; line-height: 28px; color: #4a5568;">%s</p>
									</td>
								</tr>
								<tr>
									<td style="padding: 30px 40px;">
										<table width="100%%" cellpadding="0" cellspacing="0" style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.08);">
											<tr>
												<td style="padding: 25px;">
													<table width="100%%" cellpadding="0" cellspacing="0">
														<tr>
															<td width="160" style="vertical-align: top;">
																%%product_image%%
															</td>
															<td style="vertical-align: top; padding-left: 20px;">
																<h3 style="margin: 0 0 10px; font-size: 20px; color: #1a202c;">%%product_name%%</h3>
																<p style="margin: 0 0 20px; font-size: 15px; line-height: 24px; color: #4a5568;">%%product_description%%</p>
																<a href="%%product_link%%" style="display: inline-block; background: linear-gradient(to right, #3b82f6, #2563eb); color: #fff; font-size: 15px; font-weight: 600; text-decoration: none; padding: 12px 24px; border-radius: 6px;">%s</a>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td style="padding: 30px 40px; background-color: #f8fafc; border-top: 1px solid #e2e8f0; text-align: center;">
										<p style="font-size: 15px; color: #4a5568;">%s<br><span style="color: #3b82f6; font-weight: 600;">%s</span></p>
									</td>
								</tr>
							</table>
						</td></tr>
					</table>',
					esc_html__( 'Restock Notifier For WooCommerce', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'Subscribed for:', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'Thank you for subscribing to stock notifications. We\'ll notify you as soon as the product is back in stock.', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'View Product', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'Best regards,', 'restock-notifier-for-woocommerce' ),
					esc_html__( 'The Team', 'restock-notifier-for-woocommerce' )
				)
			);
			?>
		<div class="bg-white rounded-lg shadow-card overflow-hidden">
			<div class="gradient-header border-b border-gray-200 px-6 py-4">
				<h3 class="text-lg font-semibold flex items-center text-gray-800">
					<span class="dashicons dashicons-email mr-2 text-blue-600"></span>
					<?php esc_html_e( 'Email Template Settings', 'restock-notifier-for-woocommerce' ); ?>
				</h3>
			</div>

			<div class="p-6 space-y-6">
				<!-- Email Subject -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="email_subject" class="block font-medium text-gray-700"><?php esc_html_e( 'Email Subject', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1">
							<?php
							echo wp_kses_post(
								sprintf(
								/* translators: %s will be replaced with %product_name% token. */
									__( '<code>%s</code> - to include the product name.', 'restock-notifier-for-woocommerce' ),
									'%product_name%'
								)
							);
							?>
						</p>
					</div>
					<div class="md:col-span-3">
						<input type="text" id="email_subject" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_subject]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_subject'] ?? '%product_name% is back in stock.' ); ?>" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>

				<!-- Email Body Stock-in -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="email_body" class="block font-medium text-gray-700"><?php esc_html_e( 'Email Body (stock-out or Subscribe)', 'restock-notifier-for-woocommerce' ); ?></label>
						<ul class="list-disc list-inside text-gray-500 text-sm mt-1 space-y-1">
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_name% token. */
										__( '<code>%s</code> - Product name', 'restock-notifier-for-woocommerce' ),
										'%product_name%'
									)
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_link% token. */
										__( '<code>%s</code> - Product URL', 'restock-notifier-for-woocommerce' ),
										'%product_link%'
									)
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_description% token. */
										__( '<code>%s</code> - Product Description', 'restock-notifier-for-woocommerce' ),
										'%product_description%'
									)
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_image% token. */
										__( '<code>%s</code> - Product image (HTML <code>&lt;img&gt;</code>)', 'restock-notifier-for-woocommerce' ),
										'%product_image%'
									)
								);
								?>
							</li>
						</ul>
						<p class="text-gray-500 text-xs italic mt-2">
							<?php esc_html_e( 'You may also include valid HTML tags in your email body for formatting and styling using code tab.', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
					<div class="md:col-span-3">
					<?php
						$editor_id       = 'restocknotifierpcprajapat_settings_restocknotifierpcprajapat_email_body';
						$content         = $settings['restocknotifierpcprajapat_email_body'] ?? $default_email_body;
						$editor_settings = array(
							'textarea_name' => 'restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_body]',
							'textarea_rows' => 10,
							'media_buttons' => false,
							'teeny'         => true,
							'editor_class'  => 'h-80',
						);
						wp_editor( $content, $editor_id, $editor_settings );
						?>
					</div>
				</div>

				<!-- Email Body Stock-Out -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="email_body_stock_in" class="block font-medium text-gray-700"><?php esc_html_e( 'Email Body (stock-in)', 'restock-notifier-for-woocommerce' ); ?></label>
						<ul class="list-disc list-inside text-gray-500 text-sm mt-1 space-y-1">
							<li>
								<?php
								echo wp_kses_post(
									/* translators: %s will be replaced with %product_name% token. */
									sprintf( __( '<code>%s</code> - Product name', 'restock-notifier-for-woocommerce' ), '%product_name%' )
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_link% token. */
										__( '<code>%s</code> - Product URL', 'restock-notifier-for-woocommerce' ),
										'%product_link%'
									)
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									sprintf(
									/* translators: %s will be replaced with %product_description% token. */
										__( '<code>%s</code> - Product Description', 'restock-notifier-for-woocommerce' ),
										'%product_description%'
									)
								);
								?>
							</li>
							<li>
								<?php
								echo wp_kses_post(
									/* translators: %s will be replaced with %product_image% token. */
									sprintf( __( '<code>%s</code> - Product image (HTML <code>&lt;img&gt;</code>)', 'restock-notifier-for-woocommerce' ), '%product_image%' )
								);
								?>
							</li>
						</ul>
						<p class="text-gray-500 text-xs italic mt-2">
							<?php esc_html_e( 'You may also include valid HTML tags in your email body for formatting and styling using code tab.', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
					<div class="md:col-span-3">
					<?php
						$editor_id       = 'restocknotifierpcprajapat_settings_restocknotifierpcprajapat_email_body_stock_in';
						$content         = $settings['restocknotifierpcprajapat_email_body_stock_in'] ?? $default_email_body_stock_in;
						$editor_settings = array(
							'textarea_name' => 'restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_body_stock_in]',
							'textarea_rows' => 10,
							'media_buttons' => false,
							'teeny'         => true,
							'editor_class'  => 'h-80',
						);
						wp_editor( $content, $editor_id, $editor_settings );
						?>
					</div>
				</div>

				<!-- From Name -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="from_name" class="block font-medium text-gray-700"><?php esc_html_e( 'From Name', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Name that will appear in the from field.', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<input type="text" id="from_name" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_from_name]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_from_name'] ?? get_bloginfo( 'name' ) ); ?>" class="w-full md:w-80 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>

				<!-- From Email -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="from_email" class="block font-medium text-gray-700"><?php esc_html_e( 'From Email', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Email address that will be used to send notifications.', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<input type="email" id="from_email" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_from_email]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_from_email'] ?? get_option( 'admin_email' ) ); ?>" class="w-full md:w-80 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>
				<hr/>
				<!-- Test Email -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label for="restocknotifierpcprajapattest_email" class="block font-medium text-gray-700"><?php esc_html_e( 'Test Email', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Enter test email where you send email for testing', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<input type="email" id="ssnfw_test_email" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_test_email]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_test_email'] ?? get_option( 'admin_email' ) ); ?>" class="w-full md:w-80 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>

				<!-- Actions -->
				<div class="pt-4 border-t border-gray-200">
					<button type="submit" class="px-6 py-2.5 rounded-lg gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300">
						<?php esc_html_e( 'Save Changes', 'restock-notifier-for-woocommerce' ); ?>
					</button>
					<button type="button" id="send_test_email" class="px-6 py-2.5 rounded-lg bg-white border border-primary-500 text-primary-600 font-medium shadow-md hover:shadow-lg transition-all duration-300 ml-2">
						<?php esc_html_e( 'Send Test Email', 'restock-notifier-for-woocommerce' ); ?>
					</button>
				</div>
			</div>
		</div>
	</form>
</div>
