<?php
// includes/admin/views/tab-design.php
defined( 'ABSPATH' ) || exit;
?>
<div id="design" class="tab-pane ssnfw-tab-panel" data-tab="design">
	<form action="options.php" id="design-settings-form" method="post">
	<?php
		settings_fields( 'restocknotifierpcprajapat_design' );
		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
	?>
		<div class="bg-white rounded-lg shadow-card overflow-hidden">
			<div class="gradient-header border-b border-gray-200 px-6 py-4">
				<h3 class="text-lg font-semibold flex items-center text-gray-800">
					<span class="dashicons dashicons-admin-appearance mr-2 text-primary-600"></span>
					<?php echo esc_html__( 'Design Settings', 'restock-notifier-for-woocommerce' ); ?>
				</h3>
			</div>
			<div class="p-6 space-y-6">
				<!-- Form Background Color -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="form-bg-color"><?php esc_html_e( 'Form Background Color', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1">
							<?php echo esc_html__( 'Background color of the notification form.', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
					<div class="md:col-span-3">
						<div class="color-picker-wrapper flex items-center">
							<input class="mr-2" id="form-bg-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_bg_color]" type="color" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_bg_color_text'] ?? '#ffffff' ); ?>" />
							<input
								aria-label="<?php esc_html_e( 'Background color hex value', 'restock-notifier-for-woocommerce' ); ?>"
								class="wp-input w-28" id="form-bg-color-text" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_bg_color_text]"
								type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_bg_color_text'] ?? '#ffffff' ); ?>"
								/>
						</div>
					</div>
				</div>
				<!-- Form Text Color -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="form-text-color"><?php esc_html_e( 'Form Text Color', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1">
							<?php echo esc_html__( 'Color applied to all text inside the form.', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
					<div class="md:col-span-3">
						<div class="color-picker-wrapper flex items-center">
							<input class="mr-2" id="form-text-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_text_color]" type="color"
							value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_text_color_text'] ?? '#000000' ); ?>" />
							<input
								aria-label="<?php esc_html_e( 'Text color hex value', 'restock-notifier-for-woocommerce' ); ?>"
								class="wp-input w-28" id="form-text-color-text" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_text_color_text]"
								type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_text_color_text'] ?? '#000000' ); ?>" />
						</div>
					</div>
				</div>
				<!-- Form Width -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="form-width"><?php esc_html_e( 'Form Width', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-xs text-gray-500 mt-1">
							<?php esc_html_e( 'Enter a value in px or % (e.g., 400px or 100%)', 'restock-notifier-for-woocommerce' ); ?>
						</p>
					</div>
					<div class="md:col-span-3">
						<input aria-label="Form width value" class="wp-input w-32" id="form-width"
							name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_width]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_width'] ?? '100%' ); ?>" />
					</div>
				</div>
				<!-- Form Border -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="form-border-size"><?php esc_html_e( 'Form Border', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Define the border size and color around the form.', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					</div>
					<div class="md:col-span-3 flex items-center">
						<input aria-label="Border size in pixels" class="wp-input w-20 mr-3" id="form-border-size" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_border_size]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_border_size'] ?? '1' ); ?>" />
						<span class="text-xs text-gray-500 mr-3">px</span>
						<div class="color-picker-wrapper flex items-center">
							<input class="mr-2" id="form-border-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_border_color]" type="color"
								value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_border_color_text'] ?? '#dddddd' ); ?>" />
							<input
								aria-label="<?php esc_html_e( 'Border color hex value', 'restock-notifier-for-woocommerce' ); ?>"
								class="wp-input w-28" id="form-border-color-text"
								name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_border_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_border_color_text'] ?? '#dddddd' ); ?>" />
						</div>
					</div>
				</div>
				<!-- Form Border Radius -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="form-border-radius"><?php esc_html_e( 'Form Border Radius', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Apply rounded corners to the form.', 'restock-notifier-for-woocommerce' ); ?>
					</p>
						
					</div>
					<div class="md:col-span-3">
						<input
							aria-label="<?php esc_html_e( 'Border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
							class="wp-input w-20 mr-3" id="form-border-radius" min="0"
							name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_form_border_radius]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_form_border_radius'] ?? '4' ); ?>" />
						<span class="text-xs text-gray-500">px</span>
					</div>
				</div>
				<!-- Form Margin -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label
							class="font-medium text-gray-700"><?php esc_html_e( 'Form Margin', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Space around the outside of the form (Top, Right, Bottom, Left).', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					<p class="text-xs text-gray-500 mt-1"><?php esc_html_e( 'Values in pixels (px)', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<div class="flex space-x-2">
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Top margin in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="margin-top" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_margin_top]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_margin_top'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="margin-top"><?php esc_html_e( 'Top', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Right margin in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="margin-right" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_margin_right]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_margin_right'] ?? '0' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="margin-right"><?php esc_html_e( 'Right', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Bottom margin in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="margin-bottom" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_margin_bottom]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_margin_bottom'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="margin-bottom"><?php esc_html_e( 'Bottom', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Left margin in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="margin-left" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_margin_left]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_margin_left'] ?? '0' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="margin-left"><?php esc_html_e( 'Left', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
						</div>
					</div>
				</div>
				<!-- Form Padding -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label
							class="font-medium text-gray-700"><?php esc_html_e( 'Form Padding', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Space inside the form (Top, Right, Bottom, Left).', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					<p class="text-xs text-gray-500 mt-1"><?php esc_html_e( 'Values in pixels (px)', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<div class="flex space-x-2">
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Top padding in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="padding-top" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_padding_top]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_padding_top'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="padding-top"><?php esc_html_e( 'Top', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Right padding in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="padding-right" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_padding_right]" type="number"
									value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_padding_right'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="padding-right"><?php esc_html_e( 'Right', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Bottom padding in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="padding-bottom" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_padding_bottom]" type="number"
									value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_padding_bottom'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="padding-bottom"><?php esc_html_e( 'Bottom', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
										aria-label="<?php esc_html_e( 'Left padding in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="padding-left" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_padding_left]" type="number"
									value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_padding_left'] ?? '20' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="padding-left"><?php esc_html_e( 'Left', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
						</div>
					</div>
				</div>
				<!-- Email Field Border -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="email-field-border-size"><?php esc_html_e( 'Email Field Border', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Define the border size and color around the email input field.', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					</div>
					<div class="md:col-span-3 flex items-center">
						<input aria-label="Email field border size in pixels" class="wp-input w-20 mr-3" id="email-field-border-size" min="0"
							name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_size]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_size'] ?? '1' ); ?>" />
						<span class="text-xs text-gray-500 mr-3">px</span>
						<div class="color-picker-wrapper flex items-center">
							<input class="mr-2" id="email-field-border-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_color]" type="color"
								value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_color_text'] ?? '#dddddd' ); ?>" />
							<input
								aria-label="<?php esc_html_e( 'Email field border color hex value', 'restock-notifier-for-woocommerce' ); ?>"
								class="wp-input w-28" id="email-field-border-color-text"
								name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_color_text'] ?? '#dddddd' ); ?>" />
						</div>
					</div>
				</div>
				<!-- Email Field Border Radius -->
				<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
					<div class="md:col-span-2">
						<label class="font-medium text-gray-700"
							for="email-field-border-radius"><?php esc_html_e( 'Email Field Border Radius', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-xs text-gray-500 mt-1">
						<?php esc_html_e( 'Apply rounded corners to the email input field.', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					</div>
					<div class="md:col-span-3">
						<div class="flex space-x-2">
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Top border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="email-field-border-radius-top" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_radius_top]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_radius_top'] ?? '6' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="email-field-border-radius-top"><?php esc_html_e( 'Top', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Right border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
											class="wp-input w-16" id="email-field-border-radius-right" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_radius_right]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_radius_right'] ?? '0' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="email-field-border-radius-right"><?php esc_html_e( 'Right', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Bottom border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-16" id="email-field-border-radius-bottom" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_radius_bottom]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_radius_bottom'] ?? '0' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="email-field-border-radius-bottom"><?php esc_html_e( 'Bottom', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
							<div class="flex flex-col items-center">
								<input
									aria-label="<?php esc_html_e( 'Left border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-16" id="email-field-border-radius-left" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_email_field_border_radius_left]"
									type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_email_field_border_radius_left'] ?? '6' ); ?>" />
								<label class="text-xs text-gray-500 mt-1"
									for="email-field-border-radius-left"><?php esc_html_e( 'Left', 'restock-notifier-for-woocommerce' ); ?></label>
							</div>
						</div>
					</div>
				</div>
				<!-- Button Settings -->
				<div class="bg-gray-50 rounded-lg p-6">
					<h4 class="text-lg font-semibold mb-4 text-gray-800"><?php esc_html_e( 'Button Settings', 'restock-notifier-for-woocommerce' ); ?></h4>
					<div class="space-y-6">
						<!-- Button Text -->
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-text"><?php esc_html_e( 'Button Text', 'restock-notifier-for-woocommerce' ); ?></label>
							<p class="text-gray-500 text-sm mt-1">
								<?php echo esc_html__( 'Text displayed on the submit button.', 'restock-notifier-for-woocommerce' ); ?>
							</p>
							</div>
							<div class="md:col-span-3">
								<input
									aria-label="<?php esc_html_e( 'Button text', 'restock-notifier-for-woocommerce' ); ?>"
									class="wp-input w-full max-w-xs" id="button-text" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_text]" type="text"
									value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_text'] ?? 'Notify Me' ); ?>" />
							</div>
						</div>
						<!-- Button Background Color -->
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-bg-color"><?php esc_html_e( 'Button Background Color', 'restock-notifier-for-woocommerce' ); ?></label>
							<p class="text-gray-500 text-sm mt-1">
								<?php echo esc_html__( 'Background color of the submit button.', 'restock-notifier-for-woocommerce' ); ?>
							</p>
							</div>
							<div class="md:col-span-3">
								<div class="color-picker-wrapper flex items-center">
									<input class="mr-2" id="button-bg-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_bg_color]" type="color"
										value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_bg_color_text'] ?? '#2271b1' ); ?>" />
									<input
										aria-label="<?php esc_html_e( 'Button background color hex value', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-28" id="button-bg-color-text" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_bg_color_text]"
										type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_bg_color_text'] ?? '#2271b1' ); ?>" />
								</div>
							</div>
						</div>
						<!-- Button Text Color -->
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-text-color"><?php esc_html_e( 'Button Text Color', 'restock-notifier-for-woocommerce' ); ?></label>
							<p class="text-gray-500 text-sm mt-1">
								<?php echo esc_html__( 'Color of the text on the submit button.', 'restock-notifier-for-woocommerce' ); ?>
							</p>
							</div>
							<div class="md:col-span-3">
								<div class="color-picker-wrapper flex items-center">
									<input class="mr-2" id="button-text-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_text_color]" type="color"
										value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_text_color_text'] ?? '#ffffff' ); ?>" />
									<input
										aria-label="<?php esc_html_e( 'Button text color hex value', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-28" id="button-text-color-text"
										name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_text_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_text_color_text'] ?? '#ffffff' ); ?>" />
								</div>
							</div>
						</div>
						<!-- Button Border -->
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-border-size"><?php esc_html_e( 'Button Border', 'restock-notifier-for-woocommerce' ); ?></label>
							<p class="text-xs text-gray-500 mt-1">
								<?php esc_html_e( 'Define the border size and color around the button.', 'restock-notifier-for-woocommerce' ); ?>
							</p>
							</div>
							<div class="md:col-span-3 flex items-center">
								<input aria-label="Button border size in pixels" class="wp-input w-20 mr-3" id="button-border-size" min="0"
									name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_size]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_size'] ?? '1' ); ?>" />
								<span class="text-xs text-gray-500 mr-3">px</span>
								<div class="color-picker-wrapper flex items-center">
									<input class="mr-2" id="button-border-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_color]" type="color"
										value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_color_text'] ?? '#2271b1' ); ?>" />
									<input
										aria-label="<?php esc_html_e( 'Button border color hex value', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-28" id="button-border-color-text"
										name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_color_text'] ?? '#dddddd' ); ?>" />
								</div>
							</div>
						</div>
						<!-- Button Border Radius -->
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-border-radius"><?php esc_html_e( 'Button Border Radius', 'restock-notifier-for-woocommerce' ); ?></label>
							<p class="text-xs text-gray-500 mt-1">
								<?php esc_html_e( 'Apply rounded corners to the button.', 'restock-notifier-for-woocommerce' ); ?>
							</p>
							</div>
							<div class="md:col-span-3">
								<div class="flex space-x-2">
									<div class="flex flex-col items-center">
										<input
											aria-label="<?php esc_html_e( 'Top border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
											class="wp-input w-16" id="button-border-radius-top" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_radius_top]" type="number" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_radius_top'] ?? '0' ); ?>" />
										<label class="text-xs text-gray-500 mt-1"
											for="button-border-radius-top"><?php esc_html_e( 'Top', 'restock-notifier-for-woocommerce' ); ?></label>
									</div>
									<div class="flex flex-col items-center">
										<input
											aria-label="<?php esc_html_e( 'Right border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
											class="wp-input w-16" id="button-border-radius-right" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_radius_right]" type="number"
											value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_radius_right'] ?? '6' ); ?>" />
										<label class="text-xs text-gray-500 mt-1"
											for="button-border-radius-right"><?php esc_html_e( 'Right', 'restock-notifier-for-woocommerce' ); ?></label>
									</div>
									<div class="flex flex-col items-center">
										<input
											aria-label="<?php esc_html_e( 'Bottom border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
											class="wp-input w-16" id="button-border-radius-bottom" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_radius_bottom]" type="number"
											value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_radius_bottom'] ?? '6' ); ?>" />
										<label class="text-xs text-gray-500 mt-1"
											for="button-border-radius-bottom"><?php esc_html_e( 'Bottom', 'restock-notifier-for-woocommerce' ); ?></label>
									</div>
									<div class="flex flex-col items-center">
										<input
											aria-label="<?php esc_html_e( 'Left border radius in pixels', 'restock-notifier-for-woocommerce' ); ?>"
											class="wp-input w-16" id="button-border-radius-left" min="0" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_border_radius_left]" type="number"
											value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_border_radius_left'] ?? '0' ); ?>" />
										<label class="text-xs text-gray-500 mt-1"
											for="button-border-radius-left"><?php esc_html_e( 'Left', 'restock-notifier-for-woocommerce' ); ?></label>
									</div>
								</div>
							</div>
						</div>
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-hover-bg-color"><?php esc_html_e( 'Button Hover Background Color', 'restock-notifier-for-woocommerce' ); ?></label>
									<p class="text-xs text-gray-500 mt-1">
										<?php esc_html_e( 'Background color on button hover.', 'restock-notifier-for-woocommerce' ); ?>
									</p>
							</div>
							<div class="md:col-span-3">
								<div class="color-picker-wrapper flex items-center">
										<input class="mr-2" id="button-hover-bg-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_hover_bg_color]"
										type="color" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_hover_bg_color_text'] ?? '#135e96' ); ?>" />
									<input
										aria-label="<?php esc_attr_e( 'Button hover background color hex value', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-28" id="button-hover-bg-color-text"
										name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_hover_bg_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_hover_bg_color_text'] ?? '#135e96' ); ?>" />
								</div>
							</div>
						</div>
						<div class="grid grid-cols-1 md:grid-cols-5 gap-6 items-start">
							<div class="md:col-span-2">
								<label class="font-medium text-gray-700"
									for="button-hover-text-color"><?php esc_html_e( 'Button Hover Text Color', 'restock-notifier-for-woocommerce' ); ?></label>
									<p class="text-xs text-gray-500 mt-1">
										<?php esc_html_e( 'Text color when the button is hovered..', 'restock-notifier-for-woocommerce' ); ?>
									</p>
							</div>
							<div class="md:col-span-3">
								<div class="color-picker-wrapper flex items-center">
									<input class="mr-2" id="button-hover-text-color" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_hover_text_color]"
										type="color" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_hover_text_color_text'] ?? '#ffffff' ); ?>" />
									<input
										aria-label="<?php esc_attr_e( 'Button hover text color hex value', 'restock-notifier-for-woocommerce' ); ?>"
										class="wp-input w-28" id="button-hover-text-color-text"
										name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_button_hover_text_color_text]" type="text" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_button_hover_text_color_text'] ?? '#ffffff' ); ?>" />
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Success Message -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label class="block font-medium text-gray-700"
							for="restocknotifierpcprajapat_success_message"><?php esc_html_e( 'Success Message', 'restock-notifier-for-woocommerce' ); ?></label>
					<p class="text-gray-500 text-sm mt-1">
						<?php esc_html_e( 'Message displayed after successful subscription.', 'restock-notifier-for-woocommerce' ); ?>
					</p>
					</div>
					<div class="md:col-span-3">
						<input
							class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500"
							id="restocknotifierpcprajapat_success_message" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_success_message]" type="text"
							value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_success_message'] ?? 'You\'ll be notified when this product is back in stock.' ); ?>" />
					</div>
				</div>
				<!-- Save Button -->
				<div class="pt-4 border-t border-gray-200">
					<button
						class="px-6 py-2.5 rounded-lg gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300"
						type="submit">
						<?php esc_html_e( 'Save Changes', 'restock-notifier-for-woocommerce' ); ?>
					</button>
				</div>
			</div>
		</div>
	</form>
</div>

