<?php
/**
 * Advanced Settings tab HTML view.
 *
 * This file renders the Advanced tab in the plugin settings.
 * It includes fields for stock threshold, debug mode, cleanup settings, and batch limits.
 *
 * @package Restock_Notifier_For_Woocommerce
 * @subpackage Restock_Notifier_For_Woocommerce/Admin/Views
 */

defined( 'ABSPATH' ) || exit;

$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
?>

<!-- Advanced Tab -->
<div id="advanced" class="tab-pane hidden">
	<form method="post" action="options.php">
		<?php settings_fields( 'restocknotifierpcprajapat_advanced' ); ?>
		<div class="bg-white rounded-lg shadow-card overflow-hidden">
			<div class="gradient-header border-b border-gray-200 px-6 py-4">
				<h3 class="text-lg font-semibold flex items-center text-gray-800">
					<span class="dashicons dashicons-admin-tools mr-2 text-primary-600"></span>
					<?php esc_html_e( 'Advanced Settings', 'restock-notifier-for-woocommerce' ); ?>
				</h3>
			</div>
			<div class="p-6 space-y-6">
				<!-- Stock Threshold -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label for="restocknotifierpcprajapat_stock_threshold" class="block font-medium text-gray-700"><?php esc_html_e( 'Stock Threshold', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Minimum stock level required to trigger notifications (default: 1).', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<input type="number" id="restocknotifierpcprajapat_stock_threshold" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_stock_threshold]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_stock_threshold'] ?? 1 ); ?>"
							class="w-full md:w-64 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>

				<!-- Debug Mode -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label for="restocknotifierpcprajapat_enable_debug" class="block font-medium text-gray-700"><?php esc_html_e( 'Enable Debug Mode', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Enable logging for troubleshooting purposes.', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<label class="relative inline-flex items-center cursor-pointer">
							<input type="hidden" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_debug]" value="0" />
							<input type="checkbox" id="restocknotifierpcprajapat_enable_debug" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_debug]" class="sr-only peer" value="1"
								<?php checked( $settings['restocknotifierpcprajapat_enable_debug'] ?? '', 1 ); ?> />
							<div
								class="relative w-14 h-7 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:start-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 dark:peer-checked:bg-blue-600">
							</div>
						</label>
					</div>
				</div>

				<!-- Data Cleanup -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label for="restocknotifierpcprajapat_data_cleanup" class="block font-medium text-gray-700"><?php esc_html_e( 'Data Cleanup', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'When to delete subscriber data.', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<select name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_data_cleanup]" id="restocknotifierpcprajapat_data_cleanup" class="w-full md:w-64 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
							<option value="never" <?php selected( $settings['restocknotifierpcprajapat_data_cleanup'] ?? '', 'never' ); ?>><?php esc_html_e( 'Never', 'restock-notifier-for-woocommerce' ); ?></option>
							<option value="after_notification" <?php selected( $settings['restocknotifierpcprajapat_data_cleanup'] ?? '', 'after_notification' ); ?>><?php esc_html_e( 'After Notification', 'restock-notifier-for-woocommerce' ); ?></option>
							<option value="30_days" <?php selected( $settings['restocknotifierpcprajapat_data_cleanup'] ?? '', '30_days' ); ?>><?php esc_html_e( 'After 30 Days', 'restock-notifier-for-woocommerce' ); ?></option>
						</select>
					</div>
				</div>

				<!-- Enable Cron Jobs -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label for="restocknotifierpcprajapat_enable_cron" class="block font-medium text-gray-700"><?php esc_html_e( 'Enable Cron Jobs', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Enable automatic batch email sending every 5 minutes. Disable if you experience translation loading issues.', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<label class="relative inline-flex items-center cursor-pointer">
							<input type="hidden" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_cron]" value="0" />
							<input type="checkbox" id="restocknotifierpcprajapat_enable_cron" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_enable_cron]" class="sr-only peer" value="1"
								<?php checked( $settings['restocknotifierpcprajapat_enable_cron'] ?? 0, 1 ); ?> />
							<div
								class="relative w-14 h-7 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:start-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 dark:peer-checked:bg-blue-600">
							</div>
						</label>
					</div>
				</div>

				<!-- Notification Limit -->
				<div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
					<div class="md:col-span-1">
						<label for="restocknotifierpcprajapat_notification_limit" class="block font-medium text-gray-700"><?php esc_html_e( 'Notification Limit', 'restock-notifier-for-woocommerce' ); ?></label>
						<p class="text-gray-500 text-sm mt-1"><?php esc_html_e( 'Maximum number of emails to send per batch in every 5 minutes (0 = unlimited).', 'restock-notifier-for-woocommerce' ); ?></p>
					</div>
					<div class="md:col-span-3">
						<input type="number" id="restocknotifierpcprajapat_notification_limit" name="restocknotifierpcprajapat_settings[restocknotifierpcprajapat_notification_limit]" value="<?php echo esc_attr( $settings['restocknotifierpcprajapat_notification_limit'] ?? 50 ); ?>" class="w-full md:w-64 border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary-500 focus:border-primary-500">
					</div>
				</div>

				<!-- Submit Buttons -->
				<div class="pt-4 border-t border-gray-200">
					<button type="submit" class="px-6 py-2.5 rounded-lg gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300">
						<?php esc_html_e( 'Save Changes', 'restock-notifier-for-woocommerce' ); ?>
					</button>
				</div>
			</div>
		</div>
	</form>
</div>
