<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="flex items-center justify-between mb-20">
	<div class="flex items-center">
		<div>
			<?php
			// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
			?>
			<img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../../../assets/images/logo.png' ); ?>" alt="Restock Notifier For WooCommerce" class="plugin-logo">
			<?php
			// phpcs:enable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
			?>
		</div>
	</div>
	<div>
		<button class="px-4 py-2 rounded-lg hidden gradient-primary text-white font-medium shadow-md hover:shadow-lg transition-all duration-300 items-center">
			<span class="dashicons dashicons-editor-help mr-2"></span>
			<?php esc_html_e( 'Help', 'restock-notifier-for-woocommerce' ); ?>
		</button>
	</div>
</div>

<!-- Success Notice -->
<div class="bg-white border-l-4 border-green-500 shadow-md rounded-lg px-6 py-4 mb-6 hidden transform transition-all duration-500 ease-in-out"
	id="settings-saved">
	<div class="flex items-center">
		<div class="flex-shrink-0">
			<svg class="h-5 w-5 text-green-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
				fill="currentColor">
				<path fill-rule="evenodd"
					d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
					clip-rule="evenodd"></path>
			</svg>
		</div>
		<div class="ml-3">
			<p class="text-sm font-medium text-green-800">
				<?php esc_html_e( 'Settings saved successfully!', 'restock-notifier-for-woocommerce' ); ?>
			</p>
		</div>
		<div class="ml-auto pl-3">
			<div class="-mx-1.5 -my-1.5">
				<button type="button"
					class="inline-flex rounded-md p-1.5 text-green-500 hover:bg-green-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500"
					id="close-notice">
					<span class="sr-only">
						<?php esc_html_e( 'Dismiss', 'restock-notifier-for-woocommerce' ); ?>
					</span>
					<svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
						<path fill-rule="evenodd"
							d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
							clip-rule="evenodd"></path>
					</svg>
				</button>
			</div>
		</div>
	</div>
</div>
