<?php
/**
 * Admin Subscriber Table for Restock Notifier For WooCommerce.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

defined( 'ABSPATH' ) || exit;

class Restock_Notifier_For_Woocommerce_Subscriber_Table {
	public function __construct() {
		add_action( 'wp_ajax_restocknotifierpcprajapat_get_subscribers', array( $this, 'get_subscribers' ) );
	}

	public function get_subscribers() {
		check_ajax_referer( 'restocknotifierpcprajapat_admin_nonce', 'nonce' );

		$page   = isset( $_POST['page'] ) ? max( 1, intval( $_POST['page'] ) ) : 1;
		$limit  = isset( $_POST['limit'] ) ? max( 1, intval( $_POST['limit'] ) ) : 10;
		$offset = ( $page - 1 ) * $limit;

		$subs        = Restock_Notifier_For_Woocommerce_Subscriber_Helper::get_all( $limit, $offset );
		$total       = Restock_Notifier_For_Woocommerce_Subscriber_Helper::get_total_count();
		$total_pages = ceil( $total / $limit );
		$data        = array();

		// Debug logging
		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Subscribers query - Total: ' . $total . ', Found: ' . count( $subs ) );
		}

		foreach ( $subs as $row ) {
			$data[] = array(
				'id'            => $row->id,
				'email'         => esc_html( $row->email ),
				'product_title' => get_the_title( $row->product_id ),
				'product_link'  => get_the_permalink( $row->product_id ),
				'date_added'    => $row->date_added,
				'status'        => $row->notified ? 'Notified' : 'Waiting',
			);
		}

		wp_send_json_success(
			array(
				'subscribers'  => $data,
				'total_items'  => $total,
				'total_pages'  => $total_pages,
				'current_page' => $page,
			)
		);
	}
}
