<?php
/**
 * Admin Subscriber functionality for Restock Notifier For WooCommerce.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

defined( 'ABSPATH' ) || exit;

class Restock_Notifier_For_Woocommerce_Subscriber_Helper {

	/**
	 * Get all subscribers with pagination.
	 *
	 * @param int $limit  Number of rows to fetch.
	 * @param int $offset Offset for pagination.
	 *
	 * @return array
	 */
	public static function get_all( $limit = 1, $offset = 0 ) {
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Selecting all rows, no cache needed.
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}restocknotifierpcprajapat_subscribers ORDER BY date_added DESC LIMIT %d OFFSET %d",
				$limit,
				$offset
			)
		);
		return $results;
	}


	/**
	 * Get total subscriber count.
	 *
	 * @return int
	 */
	public static function get_total_count() {
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Selecting all rows, no cache needed.
		$count = (int) $wpdb->get_var(
			"SELECT COUNT(*) FROM {$wpdb->prefix}restocknotifierpcprajapat_subscribers"
		);

		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		return $count;
	}
}
