<?php
/**
 * Admin Subscriber Actions for Restock Notifier For WooCommerce.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

defined( 'ABSPATH' ) || exit;

class Restock_Notifier_For_Woocommerce_Subscriber_Actions {

	public function __construct() {
		add_action( 'wp_ajax_restocknotifierpcprajapat_delete_subscribers', array( $this, 'delete_subscribers' ) );
		add_action( 'admin_post_restocknotifierpcprajapat_export_subscribers_csv', array( $this, 'export_csv' ) );
	}

	public function delete_subscribers() {
		check_ajax_referer( 'restocknotifierpcprajapat_admin_nonce', 'security' );

		if ( empty( $_POST['ids'] ) || ! is_array( $_POST['ids'] ) ) {
			wp_send_json_error( 'Restock Notifier For WooCommerce: No IDs received' );
		}

		global $wpdb;
		$ids = array_map( 'intval', $_POST['ids'] );

		if ( empty( $ids ) ) {
			wp_send_json_error( 'No valid IDs.' );
		}

		// ✅ No $sql variable at all
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Deleting multiple rows directly, no cache needed.
		$wpdb->query(
			$wpdb->prepare(
				'DELETE FROM ' . $wpdb->prefix . 'restocknotifierpcprajapat_subscribers WHERE id IN (' . implode( ', ', array_fill( 0, count( $ids ), '%d' ) ) . ')',
				...$ids
			)
		);

		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Deleted subscriber IDs: ' . implode( ', ', $ids ) );
		}

		wp_send_json_success( 'Deleted successfully' );
	}



	public function export_csv() {
		if ( ! current_user_can( 'manage_woocommerce' ) ) {
			wp_die( 'Unauthorized', '', array( 'response' => 403 ) );
		}

		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Selecting all rows, no cache needed.
		$rows = $wpdb->get_results(
			"SELECT * FROM {$wpdb->prefix}restocknotifierpcprajapat_subscribers",
			ARRAY_A
		);

		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Exporting ' . count( $rows ) . ' subscribers to CSV.' );
		}

		// Prepare CSV content into a string
		$csv_data  = '';
		$csv_data .= implode( ',', array( 'ID', 'Email', 'Product Name', 'Status', 'Date Added' ) ) . "\n";

		foreach ( $rows as $row ) {
			$csv_data .= implode(
				',',
				array(
					$row['id'],
					$row['email'],
					str_replace( ',', ' ', get_the_title( $row['product_id'] ) ), // avoid breaking CSV
					$row['notified'] ? 'Notified' : 'Waiting',
					$row['date_added'],
				)
			) . "\n";
		}

		// Use WP_Filesystem to write and read
		require_once ABSPATH . 'wp-admin/includes/file.php';
		WP_Filesystem();
		global $wp_filesystem;

		$temp_file = wp_tempnam( 'subscribers-export.csv' );
		$wp_filesystem->put_contents( $temp_file, $csv_data, FS_CHMOD_FILE );

		// Output headers for download
		header( 'Content-Type: text/csv' );
		header( 'Content-Disposition: attachment; filename="subscribers-export.csv"' );

		// Read file content via WP_Filesystem
		$file_content = $wp_filesystem->get_contents( $temp_file );
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Outputting CSV data, no need to escape.
		echo esc_html( $file_content );

		// Delete file the WP way
		wp_delete_file( $temp_file );

		exit;
	}
}
