<?php
/**
 * Debug logger for Restock Notifier For WooCommerce.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

class Restock_Notifier_For_Woocommerce_Logger {
	public static function log( $message ) {
		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		$enabled  = ! empty( $settings['restocknotifierpcprajapat_enable_debug'] );
		if ( ! $enabled ) {
			return;
		}

		if ( is_array( $message ) || is_object( $message ) ) {
			$message = wp_json_encode( $message, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES );
		}

		$upload_dir = wp_upload_dir();
		$log_dir    = $upload_dir['basedir'] . '/restock-notifier-for-woocommerce/';
		if ( ! file_exists( $log_dir ) ) {
			wp_mkdir_p( $log_dir );
		}

		$log_file  = $log_dir . 'restock-notifier-for-woocommerce-debug.log';
		$timestamp = current_time( 'mysql' );
		$entry     = "[$timestamp] $message\n";
		// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Safe use for optional debug logging based on plugin settings.
		error_log( "[$timestamp] [WSN Debug] Logged: $message\n", 3, $log_file );
	}

	public static function get_log_contents() {
		$upload_dir = wp_upload_dir();
		$log_file   = $upload_dir['basedir'] . '/restock-notifier-for-woocommerce/restock-notifier-for-woocommerce-debug.log';
		if ( file_exists( $log_file ) ) {
			return file_get_contents( $log_file );
		}
		return __( 'Log file not found or empty.', 'restock-notifier-for-woocommerce' );
	}
}
