<?php
/**
 * Handles AJAX request to send a test email from admin.
 *
 * @package Restock_Notifier_For_Woocommerce
 */

defined( 'ABSPATH' ) || exit;

class Restock_Notifier_For_Woocommerce_AJAX_Send_Test_Email {

	/**
	 * Initialize AJAX handler.
	 */
	public static function init() {
		add_action( 'wp_ajax_restocknotifierpcprajapat_send_test_email', array( __CLASS__, 'send_test_email' ) );
	}

	/**
	 * Send test email to provided address.
	 */
	public static function send_test_email() {
		check_ajax_referer( 'restocknotifierpcprajapat_admin_nonce', 'nonce' );

		$test_email = '';

		if ( isset( $_POST['email'] ) ) {
			$test_email = sanitize_email( wp_unslash( $_POST['email'] ) );
		}

		if ( empty( $test_email ) || ! is_email( $test_email ) ) {
			wp_send_json_error( __( 'Invalid test email address.', 'restock-notifier-for-woocommerce' ) );
		}

		// Get all settings from options
		$settings = get_option( 'restocknotifierpcprajapat_settings', array() );
		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Test email requested to: ' . $test_email );
		}

		$body_template = $settings['restocknotifierpcprajapat_email_body_stock_in'] ?? '';

		$subject = 'Test Email From Restock Notifier For WooCommerce Plugin';
		$body    = wp_kses_post(
			sprintf(
				'<div style="font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif; background-color: #f3f4f6; padding: 40px 20px;">
				<div style="max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);">
					<div style="background: linear-gradient(135deg, #4f46e5, #3b82f6); padding: 30px 40px;">
						<h1 style="color: #ffffff; margin: 0; font-size: 24px;">📧 %s <span style="color: #bbf7d0;">%s</span></h1>
					</div>
					<div style="padding: 30px 40px; color: #374151;">
						<p style="font-size: 16px; margin: 0 0 15px;">%s</p>
						<p style="font-size: 16px; line-height: 1.6; margin: 0 0 15px;">%s</p>
						<p style="font-size: 16px; line-height: 1.6; margin: 0 0 30px;">%s</p>
						<div style="text-align: center;">
							<a href="%s" target="_blank" style="display: inline-block; background-color: #3b82f6; color: #ffffff; text-decoration: none; padding: 12px 24px; border-radius: 6px; font-weight: 500; font-size: 16px;">%s</a>
						</div>
					</div>
					<div style="background-color: #f9fafb; padding: 20px 40px; font-size: 12px; color: #6b7280; text-align: center;">
						%s <a href="%s" style="color: #3b82f6; text-decoration: none;">Restock Notifier For WooCommerce Plugin</a>.<br>
						&copy; %s Your Company. %s
					</div>
				</div>
			</div>',
				esc_html__( 'Test Email from', 'restock-notifier-for-woocommerce' ),
				'Restock Notifier For WooCommerce',
				esc_html__( 'Hello 👋,', 'restock-notifier-for-woocommerce' ),
				esc_html__( 'This is a test email sent from your WordPress Restock Notifier For WooCommerce plugin to verify that your email system is working correctly.', 'restock-notifier-for-woocommerce' ),
				esc_html__( 'You can customize real emails layout to match your branding or include more dynamic content like product details and links etc.', 'restock-notifier-for-woocommerce' ),
				esc_url( site_url() ),
				esc_html__( 'Visit Your Site', 'restock-notifier-for-woocommerce' ),
				esc_html__( 'You received this email because a test was triggered from your', 'restock-notifier-for-woocommerce' ),
				esc_url( admin_url( 'admin.php?page=restock-notifier-for-woocommerce' ) ),
				gmdate( 'Y' ),
				esc_html__( 'All rights reserved.', 'restock-notifier-for-woocommerce' )
			)
		);

		$final_body = wp_kses_post( wpautop( $body ) );

		$from_name  = $settings['restocknotifierpcprajapat_from_name'] ?? get_bloginfo( 'name' );
		$from_email = $settings['restocknotifierpcprajapat_from_email'] ?? get_option( 'admin_email' );

		$headers = array(
			'Content-Type: text/html; charset=UTF-8',
			'From: ' . $from_name . ' <' . $from_email . '>',
		);

		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Sending email from: ' . $from_email );
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Subject: ' . $subject );
		}

		$sent = wp_mail( $test_email, $subject, $final_body, $headers );

		if ( 1 === (int) $settings['restocknotifierpcprajapat_enable_debug'] && ! empty( $settings['restocknotifierpcprajapat_enable_debug'] ) ) {
			Restock_Notifier_For_Woocommerce_Logger::log( '[WSN Debug] Email send status: ' . ( $sent ? 'success' : 'failure' ) );
		}

		if ( $sent ) {
			wp_send_json_success( __( 'Test email sent successfully!', 'restock-notifier-for-woocommerce' ) );
		} else {
			wp_send_json_error( __( 'Failed to send test email.', 'restock-notifier-for-woocommerce' ) );
		}
	}
}
