document.addEventListener('DOMContentLoaded', function() {
    /**
     * Tab navigation
     */
    const tabs = document.querySelectorAll('[id$="-tab"]');
    const tabPanes = document.querySelectorAll('.tab-pane');

    const activateTab = (tabId) => {
        tabs.forEach(tab => {
            tab.classList.remove('tab-active');
            tab.classList.add('tab-inactive');
        });
        tabPanes.forEach(pane => pane.classList.add('hidden'));

        const selectedTab = document.getElementById(tabId + '-tab');
        const selectedPane = document.getElementById(tabId);
        if (selectedTab && selectedPane) {
            selectedTab.classList.remove('tab-inactive');
            selectedTab.classList.add('tab-active');
            selectedPane.classList.remove('hidden');
        }
    };

    // Tab click handler with redirect
    tabs.forEach(tab => {
        tab.addEventListener('click', function () {
            const tabId = this.id.replace('-tab', '');
            const url = new URL(window.location.href);
            url.searchParams.set('tab', tabId);
            window.location.href = url.toString(); // force reload with tab param
        });
    });

    // On page load: check for ?tab= param
    const urlParams = new URLSearchParams(window.location.search);
    const currentTab = urlParams.get('tab') || 'general';
    activateTab(currentTab);
    
    

    /**
     * Show/hide shortcode field based on selection
     */
    const displayFormSelect = document.getElementById('restocknotifierpcprajapat_display_form_after');
    const shortCodeRow = document.getElementById('shortcode_row');
    if (displayFormSelect && shortCodeRow) {
        displayFormSelect.addEventListener('change', function() {
            if (this.value === 'shortcode') {
                shortCodeRow.classList.remove('hidden');
            } else {
                shortCodeRow.classList.add('hidden');
            }
        });
    }


    /**
     * Copy shortocde
     */
    const copyBtn = document.getElementById('copy-shortcode');
	const shortcodeEl = document.getElementById('restocknotifierpcprajapat-shortcode');
	if (copyBtn && shortcodeEl) {
		copyBtn.addEventListener('click', function () {
			const text = shortcodeEl.textContent.trim();

			// Use modern Clipboard API if available
			if (navigator.clipboard && navigator.clipboard.writeText) {
				navigator.clipboard.writeText(text).then(function () {
					copyBtn.innerHTML = '<span class="dashicons dashicons-yes text-green-600"></span>';
					setTimeout(() => {
						copyBtn.innerHTML = '<span class="dashicons dashicons-admin-page"></span>';
					}, 2000);
							}).catch(function (err) {
				// Copy failed silently
			});
			} else {
				// Fallback for older browsers
				const tempInput = document.createElement('textarea');
				tempInput.value = text;
				document.body.appendChild(tempInput);
				tempInput.select();
				try {
					document.execCommand('copy');
					copyBtn.innerHTML = '<span class="dashicons dashicons-yes text-green-600"></span>';
					setTimeout(() => {
						copyBtn.innerHTML = '<span class="dashicons dashicons-admin-page"></span>';
					}, 2000);
				} catch (err) {
					// Fallback copy failed silently
				}
				document.body.removeChild(tempInput);
			}
		});
	}

    
    /**
     * Send test email
     */
    const sendTestBtn = document.getElementById('send_test_email');
    if (sendTestBtn) {
        sendTestBtn.addEventListener('click', function () {
            const testEmail = document.getElementById('ssnfw_test_email')?.value;
    
            if (!testEmail || !testEmail.includes('@')) {
                alert('Please enter a valid test email address.');
                return;
            }
    
            fetch(restocknotifierpcprajapatAdmin.ajax_url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    action: 'restocknotifierpcprajapat_send_test_email',
                    nonce: restocknotifierpcprajapatAdmin.nonce,
                    email: testEmail
                })
            })
            .then(res => res.json())
            .then(data => {
                alert(data.data || 'Test email sent!');
            })
            			.catch(err => {
				alert('Failed to send test email.');
			});
        });
    }
    
    
    /**
     * form preview in design tab
     */
    // Update color input text when color picker changes
    document.querySelectorAll('input[type="color"]').forEach(colorInput => {
        colorInput.addEventListener('input', function() {
            const textInput = document.getElementById(this.id + '-text');
            if (textInput) {
                textInput.value = this.value;
            }
            updatePreview();
        });
    });

    // Update color picker when text input changes
    document.querySelectorAll('input[id$="-color-text"]').forEach(textInput => {
        textInput.addEventListener('input', function() {
            const colorId = this.id.replace('-text', '');
            const colorInput = document.getElementById(colorId);
            if (colorInput && this.value.startsWith('#') && (this.value.length === 4 || this.value
                    .length === 7)) {
                colorInput.value = this.value;
                updatePreview();
            }
        });
    });

    // Update preview when any input changes
    document.querySelectorAll('input').forEach(input => {
        input.addEventListener('input', updatePreview);
    });

    // Update the preview based on current settings
    function updatePreview() {
        const preview = document.getElementById('restocknotifierpcprajapat_front_subscriber_form');
        const previewButton = document.getElementById('preview-button');
        const formHeading = document.getElementById('form-heading');

        // Check if preview elements exist
        if (!preview || !previewButton || !formHeading) {
            console.log('Preview elements not found:', { preview, previewButton, formHeading });
            return;
        }

        // Form settings
        const bgColor = document.getElementById('form-bg-color')?.value || '#ffffff';
        const textColor = document.getElementById('form-text-color')?.value || '#000000';
        const borderSize = document.getElementById('form-border-size')?.value || '1';
        const borderColor = document.getElementById('form-border-color')?.value || '#dddddd';
        const borderRadius = document.getElementById('form-border-radius')?.value || '4';
        const marginTop = document.getElementById('margin-top')?.value || '20';
        const marginRight = document.getElementById('margin-right')?.value || '0';
        const marginBottom = document.getElementById('margin-bottom')?.value || '20';
        const marginLeft = document.getElementById('margin-left')?.value || '0';
        const paddingTop = document.getElementById('padding-top')?.value || '20';
        const paddingRight = document.getElementById('padding-right')?.value || '20';
        const paddingBottom = document.getElementById('padding-bottom')?.value || '20';
        const paddingLeft = document.getElementById('padding-left')?.value || '20';
        const width = document.getElementById('form-width')?.value || '100%';

        // Email field settings
        const emailField = document.getElementById('preview-email-field');
        const emailFieldBorderSize = document.getElementById('email-field-border-size')?.value || '1';
        const emailFieldBorderColor = document.getElementById('email-field-border-color')?.value || '#dddddd';
        const emailFieldBorderRadiusTop = document.getElementById('email-field-border-radius-top')?.value || '6';
        const emailFieldBorderRadiusRight = document.getElementById('email-field-border-radius-right')?.value || '0';
        const emailFieldBorderRadiusBottom = document.getElementById('email-field-border-radius-bottom')?.value || '0';
        const emailFieldBorderRadiusLeft = document.getElementById('email-field-border-radius-left')?.value || '6';

        // Button settings
        const buttonText = document.getElementById('button-text')?.value || 'Notify Me';
        const buttonBgColor = document.getElementById('button-bg-color')?.value || '#2271b1';
        const buttonTextColor = document.getElementById('button-text-color')?.value || '#ffffff';
        const buttonBorderSize = document.getElementById('button-border-size')?.value || '1';
        const buttonBorderColor = document.getElementById('button-border-color')?.value || '#2271b1';
        const buttonBorderRadiusTop = document.getElementById('button-border-radius-top')?.value || '0';
        const buttonBorderRadiusRight = document.getElementById('button-border-radius-right')?.value || '6';
        const buttonBorderRadiusBottom = document.getElementById('button-border-radius-bottom')?.value || '6';
        const buttonBorderRadiusLeft = document.getElementById('button-border-radius-left')?.value || '0';
        const buttonHoverBgColor = document.getElementById('button-hover-bg-color')?.value || '#135e96';
        const buttonHoverTextColor = document.getElementById('button-hover-text-color')?.value || '#ffffff';

        // Apply form styles
        preview.style.backgroundColor = bgColor;
        preview.style.color = textColor;
        formHeading.style.color = textColor;
        preview.style.border = `${borderSize}px solid ${borderColor}`;
        preview.style.borderRadius = `${borderRadius}px`;
        preview.style.margin = `${marginTop}px ${marginRight}px ${marginBottom}px ${marginLeft}px`;
        preview.style.padding = `${paddingTop}px ${paddingRight}px ${paddingBottom}px ${paddingLeft}px`;
        preview.style.width = width;

        // Apply email field styles
        if (emailField) {
            emailField.style.setProperty('border', `${emailFieldBorderSize}px solid ${emailFieldBorderColor}`, 'important');
            emailField.style.setProperty('border-radius', `${emailFieldBorderRadiusTop}px ${emailFieldBorderRadiusRight}px ${emailFieldBorderRadiusBottom}px ${emailFieldBorderRadiusLeft}px`, 'important');
            emailField.style.setProperty('border-right', `0px`, 'important');
        }

        // Apply button styles
        previewButton.textContent = buttonText;
        previewButton.style.backgroundColor = buttonBgColor;
        previewButton.style.color = buttonTextColor;
        previewButton.style.border = `${buttonBorderSize}px solid ${buttonBorderColor}`;
        previewButton.style.borderTopLeftRadius = `${buttonBorderRadiusTop}px`;
        previewButton.style.borderTopRightRadius = `${buttonBorderRadiusRight}px`;
        previewButton.style.borderBottomRightRadius = `${buttonBorderRadiusBottom}px`;
        previewButton.style.borderBottomLeftRadius = `${buttonBorderRadiusLeft}px`;

        // Create hover effect with CSS
        const styleElement = document.getElementById('button-hover-style') || document.createElement('style');
        styleElement.id = 'button-hover-style';
        styleElement.textContent = `
                        #preview-button:hover {
                            background-color: ${buttonHoverBgColor} !important;
                            color: ${buttonHoverTextColor} !important;
                        }
                    `;

        if (!document.getElementById('button-hover-style')) {
            document.head.appendChild(styleElement);
        }
    }
    // Initialize preview on page load
    updatePreview();

    // Delete subscriber confirmation
    const deleteLinks = document.querySelectorAll('.delete-subscriber');
    deleteLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Create a modal dialog
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 flex items-center justify-center z-50';
            modal.innerHTML = `
                <div class="fixed inset-0 bg-black bg-opacity-50 transition-opacity"></div>
                <div class="relative bg-white rounded-lg max-w-md w-full mx-4 overflow-hidden shadow-xl transform transition-all">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                                <svg class="h-6 w-6 text-red-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                </svg>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Delete Subscriber</h3>
                                <div class="mt-2">
                                    <p class="text-sm text-gray-500">Are you sure you want to delete this subscriber? This action cannot be undone.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" id="confirm-delete" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:ml-3 sm:w-auto sm:text-sm">Delete</button>
                        <button type="button" id="cancel-delete" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">Cancel</button>
                    </div>
                </div>
            `;
            document.body.appendChild(modal);
            
            // Handle modal actions
            document.getElementById('cancel-delete').addEventListener('click', function() {
                modal.remove();
            });
            
            document.getElementById('confirm-delete').addEventListener('click', function() {
                modal.remove();
                
                // Create a toast notification
                const toast = document.createElement('div');
                toast.className = 'fixed bottom-4 right-4 bg-white border-l-4 border-green-500 shadow-lg rounded-lg px-6 py-4 flex items-center z-50';
                toast.innerHTML = `
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800">Subscriber deleted successfully!</p>
                    </div>
                `;
                document.body.appendChild(toast);
                
                // Remove toast after 3 seconds
                setTimeout(() => {
                    toast.remove();
                }, 3000);
            });
        });
    });
    
    // Export CSV
    const exportCsvBtn = document.getElementById('export_csv');
    if (exportCsvBtn) {
        exportCsvBtn.addEventListener('click', function() {
            // Create a toast notification
            const toast = document.createElement('div');
            toast.className = 'fixed bottom-4 right-4 bg-white border-l-4 border-green-500 shadow-lg rounded-lg px-6 py-4 flex items-center z-50';
            toast.innerHTML = `
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-green-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-green-800">Subscribers data exported to CSV successfully!</p>
                </div>
            `;
            document.body.appendChild(toast);
            
            // Remove toast after 3 seconds
            setTimeout(() => {
                toast.remove();
            }, 3000);
        });
    }
    
    // Reset settings
    const resetSettingsBtn = document.getElementById('reset_settings');
    if (resetSettingsBtn) {
        resetSettingsBtn.addEventListener('click', function() {
            // Create a modal dialog
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 flex items-center justify-center z-50';
            modal.innerHTML = `
                <div class="fixed inset-0 bg-black bg-opacity-50 transition-opacity"></div>
                <div class="relative bg-white rounded-lg max-w-md w-full mx-4 overflow-hidden shadow-xl transform transition-all">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100 sm:mx-0 sm:h-10 sm:w-10">
                                <svg class="h-6 w-6 text-yellow-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                </svg>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">Reset Settings</h3>
                                <div class="mt-2">
                                    <p class="text-sm text-gray-500">Are you sure you want to reset all settings to default values? This action cannot be undone.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" id="confirm-reset" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-yellow-600 text-base font-medium text-white hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 sm:ml-3 sm:w-auto sm:text-sm">Reset</button>
                        <button type="button" id="cancel-reset" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">Cancel</button>
                    </div>
                </div>
            `;
            document.body.appendChild(modal);
            
            // Handle modal actions
            document.getElementById('cancel-reset').addEventListener('click', function() {
                modal.remove();
            });
            
            document.getElementById('confirm-reset').addEventListener('click', function() {
                modal.remove();
                
                // Create a toast notification
                const toast = document.createElement('div');
                toast.className = 'fixed bottom-4 right-4 bg-white border-l-4 border-green-500 shadow-lg rounded-lg px-6 py-4 flex items-center z-50';
                toast.innerHTML = `
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800">Settings have been reset to default values!</p>
                    </div>
                `;
                document.body.appendChild(toast);
                
                // Remove toast after 3 seconds
                setTimeout(() => {
                    toast.remove();
                }, 3000);
            });
        });
    }

    // Clear plugin logs
    const clearBtn = document.getElementById('restocknotifierpcprajapat_clear_logs_btn');
	console.log('Clear logs button found:', clearBtn);
	if (clearBtn) {
		clearBtn.addEventListener('click', function (e) {
			console.log('Clear logs button clicked');
			const confirmed = confirm(restocknotifierpcprajapatAdmin.confirm_clear_logs);
			if (!confirmed) {
				e.preventDefault();
				console.log('Clear logs cancelled by user');
			} else {
				console.log('Clear logs confirmed by user');
			}
		});
	} else {
		console.log('Clear logs button not found');
	}
});


/**
 * Subscriber Tab
 *
 * */
let currentPage = 1;
let totalPages = 0;
let perPage = 10;
let totalItems = 1;

function loadSubscribersTable(page = 1) {
	currentPage = page;
	perPage = parseInt(jQuery('#ssnfw-per-page').val());

	jQuery.ajax({
		url: restocknotifierpcprajapatAdmin.ajax_url,
		method: 'POST',
		data: {
			action: 'restocknotifierpcprajapat_get_subscribers',
			nonce: restocknotifierpcprajapatAdmin.nonce,
			page: page,
			limit: perPage
		},
		success: function (response) {
			console.log('Subscribers AJAX response:', response);
			if (!response.success) {
				console.log('Subscribers AJAX failed:', response);
				return;
			}

			const tbody = jQuery('#subscribers table tbody');
			tbody.empty();
            if (response.data.subscribers.length === 0) {
                jQuery('#restocknotifierpcprajapat_subscribers_data').hide();
                jQuery('#ssnfw-subscribers-empty').show(); // avoid duplicates
                return;
            } else {
                jQuery('#restocknotifierpcprajapat_subscribers_data').show();
                jQuery('#ssnfw-subscribers-empty').hide();
            }

            totalItems = response.data.total_items;
			response.data.subscribers.forEach(sub => {
				const statusClass = sub.status === 'Notified'
					? 'bg-green-100 text-green-800'
					: 'bg-yellow-100 text-yellow-800';

				tbody.append(`
					<tr class="hover:bg-gray-50 transition-colors duration-200">
						<td class="px-4 py-3 whitespace-nowrap">
							<input type="checkbox" name="subscriber[]" value="${sub.id}" class="rounded border-gray-300 text-primary-600 focus:ring-primary-500">
						</td>
						<td class="px-4 py-3 whitespace-nowrap font-medium">${sub.email}</td>
						<td class="px-4 py-3 whitespace-nowrap">
							<a href="${sub.product_link}" target="_blank" class="text-primary-600 hover:text-primary-800 hover:underline">${sub.product_title}</a>
						</td>
						<td class="px-4 py-3 whitespace-nowrap text-gray-600">${sub.date_added}</td>
						<td class="px-4 py-3 whitespace-nowrap">
							<span class="px-3 py-1 text-xs font-medium rounded-full ${statusClass}">${sub.status}</span>
						</td>
						<td class="px-4 py-3 whitespace-nowrap text-sm">
							<a href="#" class="text-red-600 hover:text-red-900 delete-subscriber" data-id="${sub.id}">Delete</a>
						</td>
					</tr>
				`);
			});

			totalPages = response.data.total_pages;
			jQuery('#ssnfw-total-items').text(totalItems);
			jQuery('#pag-input').val(currentPage);
			jQuery('#pag-total').text('of ' + totalPages);
			jQuery('#pag-prev, #pag-first').prop('disabled', currentPage === 1);
			jQuery('#pag-next, #pag-last').prop('disabled', currentPage === totalPages);
		},
		error: function(xhr, status, error) {
			console.log('Subscribers AJAX error:', {xhr, status, error});
		}
	});
}

function deleteSubscribers(ids) {
	jQuery.ajax({
		url: restocknotifierpcprajapatAdmin.ajax_url,
		method: 'POST',
		data: {
			action: 'restocknotifierpcprajapat_delete_subscribers',
			security: restocknotifierpcprajapatAdmin.nonce,
			ids: ids
		},
		success: function (res) {
			if (res.success) loadSubscribersTable(currentPage);
			else alert('Delete failed');
		}
	});
}

jQuery(document).ready(function () {
	if (!jQuery('#subscribers').length) return;

	loadSubscribersTable();

	jQuery('#ssnfw-per-page').on('change', () => loadSubscribersTable(1));
	jQuery('#pag-first').on('click', () => currentPage > 1 && loadSubscribersTable(1));
	jQuery('#pag-prev').on('click', () => currentPage > 1 && loadSubscribersTable(currentPage - 1));
	jQuery('#pag-next').on('click', () => currentPage < totalPages && loadSubscribersTable(currentPage + 1));
	jQuery('#pag-last').on('click', () => currentPage < totalPages && loadSubscribersTable(totalPages));
	
	jQuery('#pag-input').on('change', function () {
		const page = parseInt(jQuery(this).val());
		if (page >= 1 && page <= totalPages) {
			loadSubscribersTable(page);
		} else {
			jQuery(this).val(currentPage);
		}
	});

	jQuery(document).on('click', '.delete-subscriber', function (e) {
		e.preventDefault();
		const id = jQuery(this).data('id');
		if (confirm('Are you sure you want to delete this subscriber?')) {
			deleteSubscribers([id]);
		}
	});

	jQuery(document).on('click', '#subscribers button:contains("Apply")', function () {
		const selected = jQuery('input[name="subscriber[]"]:checked').map(function () {
			return jQuery(this).val();
		}).get();

		if (selected.length === 0) {
			alert("Please select at least one subscriber to delete.");
			return;
		}

		if (confirm(`Are you sure you want to delete ${selected.length} subscriber(s)?`)) {
			deleteSubscribers(selected);
		}
	});

	jQuery(document).on('click', '#export_csv', function () {
		window.location.href = restocknotifierpcprajapatAdmin.ajax_url.replace('admin-ajax.php', 'admin-post.php') + '?action=restocknotifierpcprajapat_export_subscribers_csv';
	});

	jQuery(document).on('change', '#subscribers thead input[type="checkbox"]', function () {
		const isChecked = jQuery(this).is(':checked');
		jQuery('#subscribers tbody input[name="subscriber[]"]').prop('checked', isChecked);
	});
});