<?php
/**
 * Plugin Name: Responsive Plus - Starter Templates
 * Plugin URI: http://wordpress.org/plugins/responsive-add-ons/
 * Description: Responsive Plus - Starter Templates offers you a library of premium Elementor and block templates so you can launch your website quickly. It also offers advanced features for the Responsive theme like mega menu, white label, WooCommerce features and custom fonts.
 * Version: 3.4.3
 * Author: Cyberchimps
 * Author URI: https://cyberchimps.com/responsive-plus/
 * License: GPL2
 * Text Domain: responsive-add-ons
 * Domain Path: /languages
 *
 * @package         Responsive_Add_Ons
 */

/*
Copyright 2013  CyberChimps  (email : support@cyberchimps.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

// Set Constants.
if ( ! defined( 'RESPONSIVE_ADDONS_FILE' ) ) {
	define( 'RESPONSIVE_ADDONS_FILE', __FILE__ );
}

if ( ! defined( 'RESPONSIVE_ADDONS_DIR' ) ) {
	define( 'RESPONSIVE_ADDONS_DIR', plugin_dir_path( RESPONSIVE_ADDONS_FILE ) );
}

if ( ! defined( 'RESPONSIVE_ADDONS_DIR_URL' ) ) {
	define( 'RESPONSIVE_ADDONS_DIR_URL', plugin_dir_url( RESPONSIVE_ADDONS_FILE ) );
}

if ( ! defined( 'RESPONSIVE_ADDONS_URI' ) ) {
	define( 'RESPONSIVE_ADDONS_URI', plugins_url( '/', RESPONSIVE_ADDONS_FILE ) );
}

if ( ! defined( 'RESPONSIVE_ADDONS_VER' ) ) {
	define( 'RESPONSIVE_ADDONS_VER', '3.4.3' );
}

if ( ! defined( 'CC_APP_URL' ) ) {
	define( 'CC_APP_URL', 'https://app.cyberchimps.com' );
}

/**
 * Load WC_AM_Client class if it exists.
 */
if ( ! class_exists( 'WC_AM_Client_Addons' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'class-wc-am-client-addons.php';
}

/*
 * Instantiate WC_AM_Client class object if the WC_AM_Client class is loaded.
 */
if ( class_exists( 'WC_AM_Client_Addons' ) ) {

	$wcam_lib_responsive_addons = new WC_AM_Client_Addons( __FILE__, '', RESPONSIVE_ADDONS_VER, 'plugin', CC_APP_URL, 'Responsive Addons', 'responsive-add-ons' );
}

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-responsive-add-ons.php';

/**
 * The code that runs during plugin activation.
 */
function activate_responsive_addons() {

	$settings = get_option( 'rpro_elementor_settings' );

	if ( is_array( $settings ) ) {
		$settings['hide_wl_settings'] = 'off';
	}
	update_option( 'rpro_elementor_settings', $settings );

	require_once plugin_dir_path( __FILE__ ) . 'includes/class-responsive-add-ons-activator.php';
	Responsive_Add_Ons_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_responsive_addons() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-responsive-add-ons-deactivator.php';
	Responsive_Add_Ons_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_responsive_addons' );
register_deactivation_hook( __FILE__, 'deactivate_responsive_addons' );

/**
 * Initialize Plugin
 */
if ( class_exists( 'Responsive_Add_Ons' ) ) {

	// Initialise Class.
	$responsive = new Responsive_Add_Ons();
}

if ( ! function_exists( 'responsive_addon_load_sdk' ) ) {
	/**
	 * Loads products array.
	 *
	 * @param array $products All products.
	 *
	 * @return array Products array.
	 */
	function responsive_addon_load_sdk( $products ) {
		$theme_name = wp_get_theme();
		if ( 'Responsive' === $theme_name->get( 'Name' ) ) {
			$products[] = get_template_directory() . '/style.css';
		}
		return $products;
	}
}
add_filter( 'responsive_sdk_products', 'responsive_addon_load_sdk' );

function responsive_addons_enqueue_admin_assets( $hook ) {
    if ( $hook === 'toplevel_page_responsive' ) {
        wp_enqueue_media();
        wp_enqueue_script( 'responsive-wl-media-upload', plugin_dir_url( __FILE__ ) . 'admin/js/wl-media-upload.js', [ 'jquery' ], '1.0', true );
    }
}
add_action( 'admin_enqueue_scripts', 'responsive_addons_enqueue_admin_assets' );
