<?php
/*
Plugin Name:       ReordeRe Lite - Subcriptions For Woocommerce
Plugin URI:        https://techspawn.com/reorderre-subcriptions-for-woocommerce/
Description:       Create subscription products and manage them with ease.
Version:           1.0.3
Requires at least: 4.9
Tested up to:      6.7
WC requires at least: 3.4
WC tested up to:   5.8.0
Requires PHP:      7.0
Requires Plugins:  woocommerce
Author:            Techspawn Solutions
Author URI:        http://www.techspawn.com
License:           GNU General Public License v3.0
License URI:       http://www.gnu.org/licenses/gpl-3.0.html
Text Domain:       reordere-lite-subcriptions-for-woocommerce
*/

/**
 * Copyright: (c) [2020] - Techspawn Solutions Private Limited
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property
 * of Techspawn Solutions Private Limited. The intellectual and technical
 * concepts contained herein are proprietary to Techspawn Solutions Private
 * Limited. Dissemination or reproduction of this material is strictly
 * forbidden unless prior written permission is obtained from Techspawn Solutions.
 *
 * @link    http://www.techspawn.com
 * @since   1.0.0
 * @package Wcmlim
 */

// Include core functions for the Subscription Products plugin
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Declare HPOS compatibility
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

// Hook into plugin activation
register_activation_hook(__FILE__, 'rorder_create_subscription_table');
//register_activation_hook(__FILE__, 'create_subscription_order_table');
register_activation_hook(__FILE__, 'rorder_create_subscription_cron_order_table');


// Register activation hook
register_activation_hook(__FILE__, 'rorder_create_payment_retries_table');
register_activation_hook(__FILE__, 'rorder_create_retry_rules_table');

function rorder_create_payment_retries_table() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'rorder_failed_payment_retries';
    $charset_collate = $wpdb->get_charset_collate();

    // SQL to create the table
    $sql = "
    CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT AUTO_INCREMENT PRIMARY KEY,
        order_id BIGINT NOT NULL,
        payment_method VARCHAR(255) NOT NULL,
        retry_interval_value INT NOT NULL,
        retry_interval_unit ENUM('minutes', 'hours', 'days', 'weeks', 'months', 'years') NOT NULL,
        retry_count INT DEFAULT 0,
        max_retries INT DEFAULT 3,
        next_retry_at DATETIME NOT NULL,
        status ENUM('pending', 'processing', 'success', 'failed') DEFAULT 'pending',
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) $charset_collate;
    ";

    // Include WordPress's file for dbDelta function
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    // Create the table
    dbDelta($sql);
}

function rorder_create_retry_rules_table(){

    global $wpdb;

    $table_name = $wpdb->prefix . 'rorder_retry_rules';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "
    CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT AUTO_INCREMENT PRIMARY KEY,
		 rule_name VARCHAR(255) NOT NULL, -- Added rule name
        payment_method VARCHAR(255) NOT NULL,
        retry_interval_value INT NOT NULL,
        retry_interval_unit ENUM('minutes', 'hours', 'days', 'weeks', 'months', 'years') NOT NULL,
        retry_count INT DEFAULT 0,
        max_retries INT DEFAULT 3,
        next_retry_at DATETIME NOT NULL,
        status ENUM('pending', 'processing', 'success', 'failed') DEFAULT 'pending',
        notify_customer INT DEFAULT 0,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) $charset_collate;
    ";

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

dbDelta($sql);

}


function rorder_create_subscription_table() { // renamed from create_subscription_table
    global $wpdb;

    if ( rorder_check_if_table_exists('subscription_details') ) { // updated call
        return;
    }
    
    $table_name = $wpdb->prefix . 'subscription_details';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id INT AUTO_INCREMENT PRIMARY KEY,
        product_id VARCHAR(255) NOT NULL,
        subscription_type VARCHAR(255) NOT NULL,
        subscription_title VARCHAR(255) NOT NULL,
        subscription_period VARCHAR(255) NOT NULL,
        subscription_price DECIMAL(10, 2) NOT NULL,
        subscription_duration VARCHAR(255) NOT NULL,
        subscription_start_date DATETIME,
        subscription_end_date DATETIME,
        user_id INT,
        sub_status VARCHAR(255) NOT NULL,
        order_id VARCHAR(255),
        payment_mode VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}


// Create a table to store subscription orders that are created by cron with fields like ID, User ID, Subscription ID, Order ID, Order Amount and product id
function rorder_create_subscription_cron_order_table() { // renamed from create_subscription_cron_order_table
    global $wpdb;

    if ( rorder_check_if_table_exists('subscription_cron_order_details') ) { // updated call
        return;
    }
    
    $table_name = $wpdb->prefix . 'subscription_cron_order_details';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        subscription_id INT NOT NULL,
        order_id INT NOT NULL,
        order_amount DECIMAL(10, 2) NOT NULL,
        product_id VARCHAR(255) NOT NULL,
        order_renewal_date DATETIME,
        sub_status VARCHAR(255) NOT NULL,
        payment_mode VARCHAR(255) NOT NULL,
        order_created_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}




function rorder_check_current_admin_page()
{
    global $pagenow;
    if ( $pagenow === 'admin.php' && isset( $_GET['page'] ) ) {
        $page = sanitize_text_field( wp_unslash( $_GET['page'] ) );
        // Check against allowed pages
        if ( in_array( $page, array( 'subscriptions', 'bulk+subscription', 'reports', 'settings' ), true ) ) {
            return false;
        }
    }
    return true;
}

function rorder_remove_footer_admin() { // renamed from remove_footer_admin
    echo '';
}


// Load required plugin files
ob_start();
require_once plugin_dir_path(__FILE__) . 'includes/class-subscription-products-functions.php';
$output = ob_get_clean();

require_once plugin_dir_path( __FILE__ ) . 'admin/class-subscription-products-license-helper.php';
require_once plugin_dir_path( __FILE__ ) . 'analytics/reordr-woo-analytics-controller.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/helpers.php';

// Load Razorpay database migration for subscription ID column
require_once plugin_dir_path( __FILE__ ) . 'includes/class-subscription-meta-helper.php';

// Load Razorpay Subscription Manager for native subscription support
require_once plugin_dir_path( __FILE__ ) . 'payments/razorpay/class-razorpay-subscription-manager.php';

// Load Razorpay token storage hooks for subscription renewals (BACKUP METHOD)
// Note: Razorpay Subscription Manager is now primary method, this is fallback
require_once plugin_dir_path( __FILE__ ) . 'payments/razorpay/razorpay-token-storage-hook.php';





function rorder_assets_url($path = '') { // renamed from rorder_assets_url
    return esc_url(plugins_url('assets/' . $path, __FILE__));
}

function rorder_check_if_table_exists($table_name) { // renamed from check_if_table_exists
    global $wpdb;

    // Sanitize table name with the WP prefix
    $full_table_name = $wpdb->prefix . $table_name;

    // Query to check if table exists using $wpdb->prepare()
    $query = $wpdb->prepare(
        "SHOW TABLES LIKE %s",
        $full_table_name
    );

    if ($wpdb->get_var($query) == $full_table_name) {
        return true;
    } else {
        return false;
    }
}



// Hook to enqueue scripts only on WooCommerce Analytics pages
function rorder_plugin_enqueue_admin_scripts() { // renamed from rordr_plugin_enqueue_admin_scripts
    if ( is_admin() && isset($_GET['page'], $_GET['path']) ) {
        $page = sanitize_text_field( wp_unslash( $_GET['page'] ) );
        $path = sanitize_text_field( wp_unslash( $_GET['path'] ) );
        if ( 'wc-admin' === $page && 'analytics/orders' === $path ) {
            wp_enqueue_script(
                'reordere-plugin-analytics',
                plugin_dir_url(__FILE__) . 'analytics/js/rorder-analytics.js',
                array('wp-hooks', 'wp-i18n', 'wc-admin'),
                null,
                true
            );
        }
    }
}
add_action('admin_enqueue_scripts', 'rorder_plugin_enqueue_admin_scripts');

function rorder_include_external_assets() {
    // Load WordPress built-in jQuery (No need for custom jQuery.js)
    wp_enqueue_script('jquery');

    // Load WordPress built-in jQuery UI instead of external file
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-widget');
    wp_enqueue_script('jquery-ui-menu'); // If you specifically need the menu module

    // Load other external JavaScript files
    wp_enqueue_script('rorder-select2-js', plugin_dir_url(__FILE__) . 'assets/external-assets/js/select2.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('rorder-chart', plugin_dir_url(__FILE__) . 'assets/external-assets/js/chart.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('rorder-chart-adapter-date', plugin_dir_url(__FILE__) . 'assets/external-assets/js/chart-adapter-date.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('sb-sweet-js', plugins_url('', __FILE__) . '/admin/js/sweetalert.js', array('jquery'), '1.0', true);


    // Load CSS files - Use Font Awesome CDN to avoid missing font file warnings
    wp_enqueue_style('rorder-fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0', 'all');
    wp_enqueue_style('rorder-select2-css', plugin_dir_url(__FILE__) . 'assets/external-assets/css/select2.css', array(), '1.0.0', 'all');
    wp_enqueue_style('rorder-jquery-ui-css', plugin_dir_url(__FILE__) . 'assets/external-assets/css/jquery-ui.css', array(), '1.0.0', 'all');
    
    // Only load Bootstrap on product pages to avoid conflicts with WooCommerce checkout/cart
    if (is_product() || is_shop() || is_product_category() || is_product_tag()) {
        wp_enqueue_style('rorder-bootstrap-css', plugin_dir_url(__FILE__) . 'assets/external-assets/css/bootstrap.css', array(), '1.0.0', 'all');
        wp_enqueue_script('rorder-bootstrap-js', plugin_dir_url(__FILE__) . 'assets/external-assets/js/bootstrap.js', array('jquery'), '1.0.0', true);
    }
}

add_action('wp_enqueue_scripts', 'rorder_include_external_assets');






