// Global check: Exit early if on checkout or cart pages
if (jQuery('body').hasClass('woocommerce-checkout') || jQuery('body').hasClass('woocommerce-cart')) {
    // Don't run any subscription scripts on checkout/cart pages
    console.log('Subscription scripts disabled on checkout/cart');
} else {

jQuery(document).ready(function ($) {
    // Listen for changes in product_type radio buttons
    $('input[name="product_type"]').on('change', function () {
        if ($(this).val() === 'one-time-purchase') {
            $('#one-time-purchase-section').show(); // Show one-time purchase section
            $('#subscription-product-section').hide(); // Hide subscription section
        } else if ($(this).val() === 'subscription') {
            $('#one-time-purchase-section').hide(); // Hide one-time purchase section
            $('#subscription-product-section').show(); // Show subscription section
            displaySubscriptionPlans(); // Display subscription plans
        }
    });

    // If subscription dropdown is used, toggle based on selection
    $('#subscription_plan').on('change', function () {
        if ($(this).is(':checked')) {
            $('#subscription-select').show(); // Show subscription dropdown
            displaySubscriptionPlans(); // Display subscription plans
        } else {
            $('#subscription-select').hide(); // Hide subscription dropdown
        }
    });

    // Function to display subscription plans 
    function displaySubscriptionPlans() {
        $('#subscription-select').empty(); // Clear existing options
        $('#subscription-select').append(`
            <div class="delivery-frequency" style="display:block;">
                <div class="frequency-option">
                    <input type="radio" id="every-1-month" name="delivery-frequency" value="1-month" checked>
                    <label for="every-1-month">Every 1 month(s)</label>
                </div>
                <div class="frequency-option">
                    <input type="radio" id="every-2-month" name="delivery-frequency" value="2-months">
                    <label for="every-2-month">Every 2 month(s)</label>
                </div>
                <div class="frequency-option">
                    <input type="radio" id="every-3-month" name="delivery-frequency" value="3-months">
                    <label for="every-3-month">Every 3 month(s)</label>
                </div>
            </div>
        `);
    }

    // Initialize sections based on the selected radio button on page load
    const selectedProductType = $('input[name="product_type"]:checked').val();
    if (selectedProductType === 'one-time-purchase') {
        $('#one-time-purchase-section').show();
        $('#subscription-product-section').hide();
    } else if (selectedProductType === 'subscription') {
        $('#one-time-purchase-section').hide();
        $('#subscription-product-section').show();
        displaySubscriptionPlans(); // Display subscription plans
    }
});



document.addEventListener('DOMContentLoaded', function () {
    const oneTimePurchaseRadio = document.getElementById('one_time_purchase');
    const subscribeButton = document.querySelector('.single_add_to_cart_button');

    

    if (oneTimePurchaseRadio) {
        // Update the button text to "Add to Cart" if "Buy and Go" is selected
        oneTimePurchaseRadio.addEventListener('click', function () {
            if (oneTimePurchaseRadio.checked) {
                subscribeButton.textContent = "<?php echo esc_html__('Add to Cart', 'reordere-lite-subcriptions-for-woocommerce'); ?>";
            }
        });

        // Reset the button text if other options are selected (e.g., subscription plans)
        document.querySelectorAll('input[name="selected_subscription"]').forEach(function (radio) {
            radio.addEventListener('click', function () {
                if (!oneTimePurchaseRadio.checked) {
                    subscribeButton.textContent = '<?php echo esc_html($subscribe_button_text); ?>'; // Reset to subscribe button text
                }
            });
        });
    }
});


jQuery(function($) {
    // Pause subscription
    $(document).on('click', '.pause-subscription', function(e) {
        e.preventDefault();

        const orderId = $(this).data('order-id');
        $('#subscription_order_id').val(orderId);
        $('#subscription-modal').dialog({
            modal: true,
            buttons: {
                Submit: function() {
                    const pauseUntil = $('#subscription_date').val();

                    if (!pauseUntil) {
                        alert('Please select a date.');
                        return;
                    }

                    $.post(subscription_vars.ajax_url, {
                        action: 'pause_subscription',
                        security: subscription_vars.nonce,
                        order_id: orderId,
                        pause_until: pauseUntil
                    }, function(response) {
                        if (response.success) {
                            alert(response.data);
                            location.reload();
                        } else {
                            alert(response.data);
                        }
                    });

                    $(this).dialog('close');
                },
                Cancel: function() {
                    $(this).dialog('close');
                }
            }
        });
    });

    // Resume subscription
    $(document).on('click', '.resume-subscription', function(e) {
        e.preventDefault();

        const orderId = $(this).data('order-id');

        if (!confirm('Are you sure you want to resume this subscription?')) {
            return;
        }

        $.post(subscription_vars.ajax_url, {
            action: 'resume_subscription',
            security: subscription_vars.nonce,
            order_id: orderId
        }, function(response) {
            if (response.success) {
                alert(response.data);
                location.reload();
            } else {
                alert(response.data);
            }
        });
    });
});

jQuery(document).ready(function ($) {
    // Fetch subscription fields when variation is selected
    $('body').on('found_variation', 'form.variations_form', function (event, variation) {
        const variationId = variation.variation_id;

        $.ajax({
            url: subscription_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'fetch_subscription_fields',
                variation_id: variationId
            },
            success: function (response) {
                $('#subscription-fields-container').html(response);

                // Pre-select the first radio button
                const firstPlan = $('#subscription-fields-container input[name="selected_subscription"]:checked');
                if (firstPlan.length) {
                    $('#selected_plan_key').val(firstPlan.val());
                    $('#add-to-cart-button').prop('disabled', false);
                } else {
                    $('#selected_plan_key').val('');
                    $('#add-to-cart-button').prop('disabled', true);
                }
            },
            
        });
    });

    // Reset fields on variation reset
    $('body').on('reset_data', 'form.variations_form', function () {
        $('#subscription-fields-container').html('');
        $('#selected_plan_key').val('');
        $('#add-to-cart-button').prop('disabled', true);
    });

    // Handle subscription plan selection
    $('body').on('click', '.subscription-plan-card', function () {
        const $card = $(this).closest('.subscription-plan');
        const $radioButton = $card.find('input[type="radio"]');

        $radioButton.prop('checked', true);
        const planKey = $radioButton.val();
        $('#selected_plan_key').val(planKey);

        $('.subscription-plan').removeClass('selected');
        $card.addClass('selected');

        $('#add-to-cart-button').prop('disabled', false);
    });

    // Add product to cart with selected subscription plan
    $('body').on('click', '#add-to-cart-button', function () {
        const planKey = $('#selected_plan_key').val();
        const productId = $('#product_id').val();

        if (!planKey || !productId) {
            alert('Please select a subscription plan before adding to the cart.');
            return;
        }

        $.ajax({
            url: subscription_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'add_to_cart_with_plan',
                plan_key: planKey,
                product_id: productId,
                security: subscription_vars.nonce
            },
            beforeSend: function () {
                $('#add-to-cart-button').prop('disabled', true).text('Adding...');
            },
            success: function (response) {
                $('#add-to-cart-button').prop('disabled', false).text('Add to Cart');
                if (response.success) {
                    window.location.href = response.data.redirect_url;
                } else {
                    alert(response.data.message);
                }
            },
            
        });
    });
});


jQuery(document).ready(function ($) {
    // Only run on product pages (check if we're on a product page)
    if (!$('body').hasClass('single-product') && !$('body').hasClass('woocommerce-page')) {
        return; // Exit early if not on a product or WooCommerce page
    }
    
    const bodyClasses = $('body').attr('class');
    const match = bodyClasses.match(/postid-(\d+)/); // Look for 'postid-XXXX' in the body class
    const productId = match ? match[1] : null;
    
    // Only proceed if we have a product ID
    if (!productId) {
        return; // Exit if no product ID found
    }
    
    if (productId) {
        $.ajax({
            url: subscription_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'fetch_subscription_fields_single',
                product_id: productId, // Send the product ID for simple products
                security: subscription_vars.nonce, 
            },
            success: function (response) {
                $('#subscription-fields-container').html(response);

                // Pre-select the first radio button (if any)
                const firstPlan = $('#subscription-fields-container input[name="selected_subscription"]:checked');
                if (firstPlan.length) {
                    $('#selected_plan_key').val(firstPlan.val());
                    $('#add-to-cart-button').prop('disabled', false);
                } else {
                    $('#selected_plan_key').val('');
                    $('#add-to-cart-button').prop('disabled', true);
                }
            },
            
        });
    }

    // Handle subscription plan selection (clicking on the card/label)
    $('body').on('click', '.subscription-plan-card', function () {
        const $card = $(this).closest('.subscription-plan');
        const $radioButton = $card.find('input[type="radio"]');

        $radioButton.prop('checked', true);
        const planKey = $radioButton.val();
        $('#selected_plan_key').val(planKey);

        $('.subscription-plan').removeClass('selected');
        $card.addClass('selected');

        $('#add-to-cart-button').prop('disabled', false);
    });

    // Handle direct radio button clicks (critical for cart functionality!)
    $('body').on('change', 'input[name="selected_subscription"]', function () {
        const planKey = $(this).val();
        $('#selected_plan_key').val(planKey);

        $('.subscription-plan').removeClass('selected');
        $(this).closest('.subscription-plan').addClass('selected');

        $('#add-to-cart-button').prop('disabled', false);
    });

    // Add product to cart with selected subscription plan
    $('body').on('click', '#add-to-cart-button', function () {
        const planKey = $('#selected_plan_key').val();
        const productId = $('#product_id').val();

        if (!planKey || !productId) {
            alert('Please select a subscription plan before adding to the cart.');
            return;
        }

        $.ajax({
            url: subscription_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'add_to_cart_with_plan',
                plan_key: planKey,
                product_id: productId,
                security: subscription_vars.nonce
            },
            beforeSend: function () {
                $('#add-to-cart-button').prop('disabled', true).text('Adding...');
            },
            success: function (response) {
                $('#add-to-cart-button').prop('disabled', false).text('Add to Cart');
                if (response.success) {
                    window.location.href = response.data.redirect_url;
                } else {
                    alert(response.data.message);
                }
            },
            
        });
    });
});



jQuery(document).ready(function ($){
    
    // Function to handle the radio button change event
    function handleRadioChange() {
        var $subscriptionSelect = $('#subscription-select_adv_plan');
        if ($('#subscription_plan_adv_view').is(':checked')) {
            // Show the subscription dropdown when "Subscription" radio is selected
            $subscriptionSelect.show();
        } else {
            // Hide the subscription dropdown when "One-time Purchase" radio is selected
            $subscriptionSelect.hide();
        }
    }

    // Event delegation: bind to the parent container (if dynamic content is loaded)
    $('body').on('change', '.adv-radio', handleRadioChange);

   


});


jQuery(document).ready(function ($){

// Function to handle the radio button change event
function handleRadioChange1() {
    
    var $subscriptionSelect1 = $('#subscription-select_inherit'); // Get the subscription select div
    var $oneTimePurchaseRadio = $('#one_time_purchase'); // One-time purchase radio button
    var $subscriptionPlanRadio = $('#subscription_plan'); // Subscription radio button

    // Check if the "Subscription" radio button is checked
    if ($subscriptionPlanRadio.is(':checked')) {
        // Show the subscription dropdown when "Subscription" radio is selected
        $subscriptionSelect1.slideDown();
    } else {
        // Hide the subscription dropdown when "One-time Purchase" radio is selected
        $subscriptionSelect1.slideUp();
    }
}

// Event delegation: bind to the parent container (if dynamic content is loaded)
// Listen for change on any radio button with the class "inherit_radio"
$('body').on('change', '.inherit_radio', function () {
    // Uncheck the other radio button when one is checked
    if ($(this).attr('id') == 'one_time_purchase_inherit_view') {
        $('#subscription_plan').prop('checked', false); // Uncheck subscription radio
    } else if ($(this).attr('id') == 'subscription_plan') {
        $('#one_time_purchase_inherit_view').prop('checked', false); // Uncheck one-time purchase radio
    }

    // Handle the visibility and functionality of the subscription options
    handleRadioChange1();
});

// Initially set the correct visibility based on the pre-selected radio button without triggering the log
if ($('#subscription_plan').is(':checked')) {
    $('#subscription-select_inherit').show();
} else {
    $('#subscription-select_inherit').hide();
}
});

} // End of global checkout/cart check