<?php
// Add the filter for "Reorder Subscriptions" to the orders query
function rorder_apply_reorder_subscriptions_filter( $args ) {
    if ( isset( $_GET['reorder_subscriptions'] ) && sanitize_text_field( wp_unslash( $_GET['reorder_subscriptions'] ) ) === 'yes' ) {
        $args['meta_query'][] = array(
            'key'     => '_plan_type',
            'value'   => 'subscription',
            'compare' => '=',
        );
    }
    return $args;
}

add_filter( 'woocommerce_analytics_orders_query_args', 'rorder_apply_reorder_subscriptions_filter' );
add_filter( 'woocommerce_analytics_orders_stats_query_args', 'rorder_apply_reorder_subscriptions_filter' );

// Example of adding item meta to an order item
function rorder_add_subscription_plan_meta($order_id) {
    $order = wc_get_order($order_id);
    foreach ($order->get_items() as $item_id => $item) {
        $item->update_meta_data('_plan_type', 'subscription');
        $item->save();
    }
}

add_action('woocommerce_order_status_completed', 'rorder_add_subscription_plan_meta');
add_action('woocommerce_order_status_processing', 'rorder_add_subscription_plan_meta');
