import { addFilter } from "@wordpress/hooks";
import { __ } from "@wordpress/i18n";

// Add custom filter for "Reorder Subscriptions"
const addReorderSubscriptionsFilter = (filters) => {
  return [
    {
      label: __("Reorder Subscriptions", "dev-blog-example"),
      staticParams: [],
      param: "reorder_subscriptions", // Query param used to filter orders
      showFilters: () => true,
      defaultValue: "", // Default value is empty
      filters: [
        {
          label: __("Yes", "dev-blog-example"),
          value: "yes", // Value when user selects "Yes"
        },
        {
          label: __("No", "dev-blog-example"),
          value: "no", // Value when user selects "No"
        },
      ],
    },
    ...filters,
  ];
};

// Add the custom filter to WooCommerce admin orders report
addFilter(
  "woocommerce_admin_orders_report_filters",
  "dev-blog-example",
  addReorderSubscriptionsFilter
);

// Add a custom column to the orders report to show if the order contains a subscription
const addSubscriptionColumn = (reportTableData) => {
  if ("orders" !== reportTableData.endpoint) {
    return reportTableData;
  }

  const newHeaders = [
    {
      label: __("Subscription Plan", "dev-blog-example"),
      key: "subscription_plan",
    },
    ...reportTableData.headers,
  ];

  const newRows = reportTableData.rows.map((row, index) => {
    const item = reportTableData.items.data[index];
    const subscriptionStatus = item.plan_type === 'subscription' ? 'Yes' : 'No';
    const newRow = [
      {
        display: subscriptionStatus,
        value: subscriptionStatus,
      },
      ...row,
    ];
    return newRow;
  });

  reportTableData.headers = newHeaders;
  reportTableData.rows = newRows;

  return reportTableData;
};

// Add the custom column to the report table
addFilter("woocommerce_admin_report_table", "dev-blog-example", addSubscriptionColumn);
