jQuery(document).ready(function ($) {
    "use strict";

    // Handle license activation button click
    $(document).on("click", ".activate-license-btn", function (event) {
        // Log for debugging
        console.log('Activate license button clicked');

        // Get nonce and AJAX URL from localized script
        var nonce = sbLicenseNonce.nonce;
        var url = sbLicenseNonce.licenseurl;

        // Verify nonce before sending AJAX request
        if (!wp_verify_nonce(nonce, 'sb_license_nonce')) {
            Swal.fire({
                title: "Verification Error",
                text: "Nonce verification failed.",
                icon: "error",
            });
            return;
        }

        // Get email and purchase code from input fields
        var squareemail = $("#reordere_email").val();
        var squarepurchasecode = $("#reordere_licenseKey").val();

        // Send AJAX request to save license options
        $.ajax({
            url: url,
            type: "post",
            data: {
                action: "save_sb_menu_options",
                reordere_email: squareemail,
                purchase_code: squarepurchasecode,
                nonce: nonce,
            },
            success: function (response) {
                // Handle success response
                if (response == "Your License Code Has Been Validated. Thank you for your purchase.") {
                    Swal.fire({
                        title: "Success",
                        text: response,
                        icon: "success",
                    }).then((result) => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        title: "Verification Error",
                        text: response,
                        icon: "error",
                    });

                    // Clear input fields on error
                    $("#reordere_email").val("");
                    $("#reordere_licenseKey").val("");
                }
            },
        });
    });

    // Handle license removal button click
    $(document).on("click", ".remove-subscription-license", function (event) {
        // Get nonce and AJAX URL from localized script
        var nonce = sbLicenseNonce.nonce;
        var url = sbLicenseNonce.licenseurl;

        // Verify nonce before sending AJAX request
        if (!wp_verify_nonce(nonce, 'sb_license_nonce')) {
            Swal.fire({
                title: "Verification Error",
                text: "Nonce verification failed.",
                icon: "error",
            });
            return;
        }

        // Send AJAX request to remove license options
        $.ajax({
            url: url,
            type: "post",
            data: {
                action: "remove_sb_menu_options",
                nonce: nonce,
            },
            success: function (response) {
                // Handle success response
                Swal.fire({
                    title: "Success",
                    text: "Your License Has Been Successfully Removed.",
                    icon: "success",
                }).then((result) => {
                    location.reload();
                });
            },
        });
    });
});
