<?php
/**
 * Enable Subscription Products Fields
 *
 * @package TS_Subscription
 */

/**
 * Display subscription fields in the product inventory section.
 */
function rorder_enable_subscription_products_fields() {
    global $post;

    $product_id = $post->ID;
    $product = wc_get_product($product_id);
    $product_type = $product->get_type();
    wp_nonce_field('save_subscription_fields', '_subscription_nonce');
    if ($product_type !== 'simple') {
        return;
    }
    ?>
    <div id="subscription-fields-wrapper">
        <?php
        $post_id = '';
        if (isset($_GET['post'])) {
            $post_id = sanitize_text_field(wp_unslash($_GET['post']));
        } else {
            if (isset($_POST['post_ID'])) {
                $post_id = sanitize_text_field(wp_unslash($_POST['post_ID']));
            }
        }
        $enable_subscription = get_post_meta($post_id, '_enable_subscription', true);
        $subscription_product_row = get_post_meta($post_id, '_subscription_product_row', true);
        $subscription_discount_type = get_post_meta($post_id, '_subscription_discount_type', true);
        $main_subscription_title = get_post_meta($post_id, '_main_subscription_title', true);
        $data_product_id = $product_id;
        ?>
        <p class="form-field">
            <label for="main_subscription_title"><?php esc_html_e('Subscription Title', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
            <input type="text" id="main_subscription_title" name="main_subscription_title" value="<?php echo esc_attr($main_subscription_title); ?>" />
        </p>
        <div class="" style="display: flex;">
        <p class="form-field" style="flex: none;">
            <label for="enable_subscription" style="width: 160px;"><?php esc_html_e('Enable Subscription Fields', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>&nbsp;&nbsp;&nbsp;
            <input type="checkbox" id="enable_subscription" data-product-id="<?php echo esc_attr($data_product_id); ?>" class="enable_subscription" name="enable_subscription" <?php echo isset($enable_subscription) && $enable_subscription === 'yes' ? 'checked' : ''; ?> />
        </p>
    </div>
    <p class="form-field" style="margin-bottom:20px; display: flex; gap:88px; align-items: center; justify-content: space-between;">
        <label><?php esc_html_e('Discount Type :', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
        <label for="subscription_discount_type_flat" style="display: flex; align-items: center; gap: 5px; white-space: nowrap;margin-left: -114px;">
            <input type="radio" id="subscription_discount_type_flat" name="subscription_discount_type" value="flat" <?php echo isset($subscription_discount_type) && $subscription_discount_type === 'flat' ? 'checked' : ''; ?> />
            <?php esc_html_e('Flat Rate', 'reordere-lite-subcriptions-for-woocommerce'); ?>
        </label>&nbsp;

        <label for="subscription_discount_type_percentage" style="display: flex; align-items: center; gap: 5px; white-space: nowrap;margin-left: -209px;">
            <input type="radio" id="subscription_discount_type_percentage" name="subscription_discount_type" value="percentage" <?php echo isset($subscription_discount_type) && $subscription_discount_type === 'percentage' ? 'checked' : ''; ?> />
            <?php esc_html_e('Percentage Discount', 'reordere-lite-subcriptions-for-woocommerce'); ?>
        </label>&nbsp;

        <label for="subscription_discount_type_amount_off" style="display: flex; align-items: center; gap: 5px; white-space: nowrap;">
            <input type="radio" id="subscription_discount_type_amount_off" name="subscription_discount_type" value="amount_off" <?php echo isset($subscription_discount_type) && $subscription_discount_type === 'amount_off' ? 'checked' : ''; ?> />
            <?php esc_html_e('Amount Off', 'reordere-lite-subcriptions-for-woocommerce'); ?>
        </label>
    </p>

    <div id="subscription-fields-container">
        <!-- Subscription Checkbox -->
        <div id="subscription-fields">
        <?php
        if ($enable_subscription === 'yes') {
            // Set visibility via PHP instead of inline styles
            add_action('admin_footer', 'rorder_add_subscription_fields_styles');
        } else {
            add_action('admin_footer', 'rorder_add_hidden_subscription_fields_styles');
        }
        
        $subscription_fields = get_post_meta($post_id, '_subscription_fields', true);
        if (empty($subscription_fields)) {
            ?>
            <!-- Container for subscription fields -->
            <!-- Initial Row -->
            <div class="subscription-field-row" data-row-id="1">
                <!-- Subscription Title -->
                <p class="form-field p-0">
                    <label for="_subs_title_1"><?php esc_html_e('Plan Name', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="text" id="_subs_title_1" name="subscription_fields[1][_subs_title]" value="" style="height:px; padding: 0.5em; margin-bottom: 0.5em;"/>
                </p>
                <!-- Subscription Period -->
                <p class="form-field p-0">
                    <label for="_subs_period_1"><?php esc_html_e('Plan Period', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="number" id="_subs_period_1" name="subscription_fields[1][_subs_period]" value="" min="1" step="1" />
                </p>

                <!-- Subscription Period Interval -->
                <p class="form-field p-0">
                    <label for="_subs_period_interval_1"><?php esc_html_e('Plan Interval', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <select id="_subs_period_interval_1" name="subscription_fields[1][_subs_period_interval]" style="margin-bottom: 0.5em;">
                        <option value="day"><?php esc_html_e('Day(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="week"><?php esc_html_e('Week(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="month"><?php esc_html_e('Month(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="year"><?php esc_html_e('Year(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                    </select>
                </p>

                <!-- Subscription Price -->
                <p class="form-field p-0">
                    <label for="_subs_price_1"><?php esc_html_e('Plan Price', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="number" id="_subs_price_1" name="subscription_fields[1][_subs_price_field]" value="" min="0" step="0.01" class="subscription-price"/>
                </p>
                
                <input type="hidden" id="total_price_1" name="subscription_fields[1][_subs_price]" value="" />

                <!-- Delete Button (hidden for the first row) -->
                <button type="button" class="delete-field button" style="display: none;"><?php esc_html_e('Delete', 'reordere-lite-subcriptions-for-woocommerce'); ?></button>
            </div>
            <!-- Add More Button -->
            <button type="button" id="add-more-fields" class="button"><?php esc_html_e('Add More', 'reordere-lite-subcriptions-for-woocommerce'); ?></button>
            <?php
        } else {
            foreach ($subscription_fields as $key => $field) {
                $display = $key === 1 ? 'none' : 'block';
                ?>
                <!-- Container for subscription fields -->
                <!-- Initial Row -->
                <div class="subscription-field-row" data-row-id="<?php echo esc_attr($key); ?>">
                    <!-- Subscription Title -->
                    <?php
                    // Example dynamic values for period and interval
                    $period = !empty($field['_subs_period']) ? $field['_subs_period'] : 1;
                    $interval = !empty($field['_subs_period_interval']) ? $field['_subs_period_interval'] : 'month';

                    // Format the period and interval for display
                    $period_for_title = $period > 1 ? $period . ' ' : ''; // Show period only if it's greater than 1
                    $interval_for_title = ($interval === 'day') ? 'Day(s)' :
                                        (($interval === 'week') ? 'Week(s)' :
                                        (($interval === 'month') ? 'Month(s)' : 'Year(s)'));

                    // Combine to create the default title
                    $default_title = "Every {$period_for_title}{$interval_for_title}";

                    // If the user has already set a custom title, use that, otherwise use the default
                    $current_title = !empty($field['_subs_title']) ? esc_attr($field['_subs_title']) : $default_title;
                    ?>

                    <p class="form-field p-0" style="margin-top: 0;">
                        <label for="_subs_title_<?php echo esc_attr($key); ?>"><?php esc_html_e('Plan Name', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="text" id="_subs_title_<?php echo esc_attr($key); ?>" 
                            name="subscription_fields[<?php echo esc_attr($key); ?>][_subs_title]" 
                            value="<?php echo !empty($field['_subs_title']) ? esc_attr($field['_subs_title']) : 'Every {{period}} {{interval}}'; ?>" 
                            style="height:auto; padding: 0.5em; margin-bottom: 0.5em;" />
                    </p>
                    <!-- Subscription Period -->
                    <p class="form-field p-0">
                        <label for="_subs_period_<?php echo esc_attr($key); ?>"><?php esc_html_e('Plan Period', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="number" id="_subs_period_<?php echo esc_attr($key); ?>" name="subscription_fields[<?php echo esc_attr($key); ?>][_subs_period]" 
                            value="<?php echo esc_attr($field['_subs_period']); ?>" 
                            min="1" step="1"/>
                    </p>

                    <!-- Subscription Period Interval -->
                    <p class="form-field p-0">
                        <label for="_subs_period_interval_<?php echo esc_attr($key); ?>"><?php esc_html_e('Plan Interval', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <select id="_subs_period_interval_<?php echo esc_attr($key); ?>" name="subscription_fields[<?php echo esc_attr($key); ?>][_subs_period_interval]" style="margin-bottom: 0.5em;">
                            <option value="day" <?php selected($field['_subs_period_interval'], 'day'); ?>><?php esc_html_e('Day(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                            <option value="week" <?php selected($field['_subs_period_interval'], 'week'); ?>><?php esc_html_e('Week(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                            <option value="month" <?php selected($field['_subs_period_interval'], 'month'); ?>><?php esc_html_e('Month(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                            <option value="year" <?php selected($field['_subs_period_interval'], 'year'); ?>><?php esc_html_e('Year(s)', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        </select>
                    </p>

                    <p class="form-field p-0">
                        <label for="_subs_price_1"><?php esc_html_e('Plan Price', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="number" id="_subs_price_1" name="subscription_fields[<?php echo esc_attr($key); ?>][_subs_price_field]" 
                            value="<?php echo esc_attr($field['_subs_price_field']); ?>" 
                            min="0" step="0.01" class="subscription-price"/>
                    </p>

                    <?php
                    global $post;

                    // Get the product ID
                    $product_id = $post->ID;

                    // Get the product object
                    $product = wc_get_product($product_id);

                    // Initialize the subscription price and final price
                    $subscription_price = isset($field['_subs_price_field']) ? floatval($field['_subs_price_field']) : 0; // Default to 0 if not set
                    $regular_price = floatval($product->get_regular_price()); // Ensure we get the regular price
                    $subscription_discount_type = get_post_meta($post_id, '_subscription_discount_type', true);

                    // Calculate the final price based on the discount type
                    $final_price = $subscription_price; // Default to subscription price

                    if ($subscription_discount_type === 'flat') {
                        // Flat rate: use the subscription price directly
                        $final_price = $subscription_price;
                    } elseif ($subscription_discount_type === 'percentage') {
                        // Percentage discount: reduce the regular price by the percentage entered in the subscription price field
                        if ($regular_price > 0 && $subscription_price > 0) {
                            $final_price = $regular_price - ($regular_price * ($subscription_price / 100)); // Apply percentage discount
                        } else {
                            $final_price = $regular_price; // Default to regular price if conditions are not met
                        }
                    } elseif ($subscription_discount_type === 'amount_off') {
                        // Amount off: subtract the subscription price from the regular price
                        if ($regular_price > 0 && $subscription_price > 0) {
                            $final_price = max(0, $regular_price - $subscription_price); // Ensure final price is not negative
                        } else {
                            $final_price = $regular_price; // Default to regular price if conditions are not met
                        }
                    } else {
                        $final_price = $subscription_price; // Fallback to subscription price if no valid discount type is provided
                    }

                    // Format the final price for display
                    $formatted_final_price = wc_price($final_price);

                    // Display the final price in the hidden field
                    ?>
                    <input type="hidden" class="total_price" name="subscription_fields[<?php echo esc_attr($key); ?>][_subs_price]" value="<?php echo esc_attr($final_price); ?>" />

                    <!-- Delete Button (hidden for the first row) -->
                    <button type="button" class="delete-field button" style="display:<?php echo esc_attr($display); ?>"><?php esc_html_e('Delete', 'reordere-lite-subcriptions-for-woocommerce'); ?></button>
                </div>
                <?php
            }
            ?>
            <!-- Add More Button -->
            <button type="button" id="add-more-fields" class="button"><?php esc_html_e('Add More', 'reordere-lite-subcriptions-for-woocommerce'); ?></button>
            <?php
        }
        ?>
        </div>
    </div>
    </div>
    <?php
}

add_action('woocommerce_product_options_inventory_product_data', 'rorder_enable_subscription_products_fields', 10);

/**
 * Add subscription fields styles when enabled
 */
function rorder_add_subscription_fields_styles() {
    $css = "
        #subscription-fields-container {
            display: block;
        }
        #subscription-fields-split {
            display: block;
        }
        .subscription-field-row p.form-field {
            padding: 0px !important;
            padding-left: 10px !important;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            max-width: 28%;
        }
        .subscription-field-row p.form-field label {
            margin: 0px !important;
        }
        .subscription-field-row p.form-field input, .subscription-field-row p.form-field select {
            width: 100%;
            max-width: 100%;
        }
    ";
    wp_add_inline_style('woocommerce_admin_styles', $css);
}

/**
 * Add subscription fields styles when hidden
 */
function rorder_add_hidden_subscription_fields_styles() {
    $css = "
        #subscription-fields-container {
            display: none;
        }
        #subscription-fields-split {
            display: none;
        }
    ";
    wp_add_inline_style('woocommerce_admin_styles', $css);
}

/**
 * Enqueue custom scripts for the admin product edit page.
 *
 * @param string $hook The current admin page.
 */
function rorder_enqueue_custom_scripts($hook) {
    // Ensure the script is enqueued only on the product edit page.
    if ($hook !== 'post.php' && $hook !== 'post-new.php') {
        return;
    }
    if (get_post_type() !== 'product') {
        return;
    }
    
    // Enqueue your custom script
    wp_enqueue_script(
        'subscription-products-admin',
        plugin_dir_url( dirname( __FILE__ ) ) . 'js/subscription-products-admin.js',
        array('jquery'),
        '1.0.0',
        true
    );

    // Localize script to pass PHP data to JavaScript.
    wp_localize_script('subscription-products-admin', 'customData', array(
        'deleteButtonText' => esc_html__('Delete', 'reordere-lite-subcriptions-for-woocommerce'),
        'nonce' => wp_create_nonce('custom_nonce')
    ));
    
    // Enqueue admin CSS
    wp_enqueue_style(
        'subscription-products-admin-style',
        plugin_dir_url( dirname( __FILE__ ) ) . 'css/subscription-products-admin.css',
        array(),
        '1.0.0'
    );
}
add_action('admin_enqueue_scripts', 'rorder_enqueue_custom_scripts');

/**
 * Add subscription fields to product variations.
 *
 * @param int   $loop The loop index.
 * @param array $variation_data The variation data.
 * @param WP_Post $variation The variation post object.
 */
function rorder_add_subscription_fields_to_variations($loop, $variation_data, $variation) {
    // Retrieve subscription meta data.
    $enable_subscription = get_post_meta($variation->ID, '_enable_subscription', true);
    $subscription_title = get_post_meta($variation->ID, '_subscription_title', true);
    $discount_type = get_post_meta($variation->ID, '_subscription_discount_type', true);
    $subscription_fields = get_post_meta($variation->ID, '_subscription_plans', true);

    ?>
    <div class="form-row form-row-full variation-subscription-fields" data-variation-id="<?php echo esc_attr($variation->ID); ?>">
        <!-- Subscription Title -->
        <p class="form-field">
            <label for="subscription_title_<?php echo esc_attr($variation->ID); ?>"><?php esc_html_e('Subscription Title', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
            <input type="text" id="subscription_title_<?php echo esc_attr($variation->ID); ?>" name="subscription_title[<?php echo esc_attr($variation->ID); ?>]" value="<?php echo esc_attr($subscription_title); ?>" />
        </p>

        <!-- Enable Subscription -->
        <p class="form-field">
            <label for="enable_subscription_<?php echo esc_attr($variation->ID); ?>"><?php esc_html_e('Enable Subscription :',  'reordere-lite-subcriptions-for-woocommerce'); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <input type="checkbox"  id="enable_subscription_<?php echo esc_attr($variation->ID); ?>" name="enable_subscription[<?php echo esc_attr($variation->ID); ?>]" <?php checked($enable_subscription, 'yes'); ?> />
        </p>

        <!-- Discount Type -->
        <p class="form-field">
            <label><?php esc_html_e('Discount Type :', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label><input type="radio" name="subscription_discount_type[<?php echo esc_attr($variation->ID); ?>]" value="flat" <?php checked($discount_type, 'flat'); ?>> Flat</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label><input type="radio" name="subscription_discount_type[<?php echo esc_attr($variation->ID); ?>]" value="percentage" <?php checked($discount_type, 'percentage'); ?>> Percentage</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label><input type="radio" name="subscription_discount_type[<?php echo esc_attr($variation->ID); ?>]" value="amount_off" <?php checked($discount_type, 'amount_off'); ?>> Amount Off</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        </p>
  
    <!-- Subscription Plans -->
    <div class="subscription-plan-fields-container subscription-plan-fields-container-<?php echo esc_attr($variation->ID); ?>" data-variation-id="<?php echo esc_attr($variation->ID); ?>">

        <?php 
        // Check if there are existing subscription fields for the variation
        if (empty($subscription_fields) || !is_array($subscription_fields)): ?>
            <!-- Default empty subscription plan row (only if no subscription fields) -->
            <div class="subscription-plan-row">
                <p class="form-field p-0">
                    <label for="subscription_plan_name_<?php echo esc_attr($variation->ID); ?>_0"><?php esc_html_e('Plan Name', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="text" placeholder="Plan Name" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][0][name]" value="" />
                </p>
                <p class="form-field p-0">
                    <label for="subscription_plan_interval_<?php echo esc_attr($variation->ID); ?>_0"><?php esc_html_e('Plan Interval', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="number" placeholder="Interval" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][0][interval]" value="1" min="1" />
                </p>
                <p class="form-field p-0">
                    <label for="subscription_plan_period_<?php echo esc_attr($variation->ID); ?>_0"><?php esc_html_e('Plan Period', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <select name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][0][period]">
                        <option value="day">Day(s)</option>
                        <option value="week">Week(s)</option>
                        <option value="month">Month(s)</option>
                        <option value="year">Year(s)</option>
                    </select>
                </p>
                <p class="form-field p-0">
                    <label for="subscription_plan_price_<?php echo esc_attr($variation->ID); ?>_0"><?php esc_html_e('Plan Price', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="number" placeholder="Price" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][0][price]" value="0" min="0" step="0.01" />
                </p>
            </div>
        <?php endif; ?>

        <!-- Render existing subscription fields if they exist -->
        <?php 
        if (!empty($subscription_fields) && is_array($subscription_fields)) {
            foreach ($subscription_fields as $index => $field) {
                ?>
                <div class="subscription-plan-row">
                    <p class="form-field p-0">
                        <label for="subscription_plan_name_<?php echo esc_attr($variation->ID); ?>_<?php echo esc_attr($index); ?>"><?php esc_html_e('Plan Name', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="text" placeholder="Plan Name" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][<?php echo esc_attr($index); ?>][name]" value="<?php echo esc_attr($field['name']); ?>" />
                    </p>
                    <p class="form-field p-0">
                        <label for="subscription_plan_interval_<?php echo esc_attr($variation->ID); ?>_<?php echo esc_attr($index); ?>"><?php esc_html_e('Plan Interval', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="number" placeholder="Interval" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][<?php echo esc_attr($index); ?>][interval]" value="<?php echo esc_attr($field['interval']); ?>" min="1" />
                    </p>
                    <p class="form-field p-0">
                        <label for="subscription_plan_period_<?php echo esc_attr($variation->ID); ?>_<?php echo esc_attr($index); ?>"><?php esc_html_e('Plan Period', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <select name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][<?php echo esc_attr($index); ?>][period]">
                            <option value="day" <?php selected($field['period'], 'day'); ?>>Day(s)</option>
                            <option value="week" <?php selected($field['period'], 'week'); ?>>Week(s)</option>
                            <option value="month" <?php selected($field['period'], 'month'); ?>>Month(s)</option>
                            <option value="year" <?php selected($field['period'], 'year'); ?>>Year(s)</option>
                        </select>
                    </p>
                    <p class="form-field p-0">
                        <label for="subscription_plan_price_<?php echo esc_attr($variation->ID); ?>_<?php echo esc_attr($index); ?>"><?php esc_html_e('Plan Price', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                        <input type="number" placeholder="Price" name="subscription_fields[<?php echo esc_attr($variation->ID); ?>][<?php echo esc_attr($index); ?>][price]" value="<?php echo esc_attr($field['price']); ?>" min="0" step="0.01" />
                    </p>
                    <?php if ($index > 0): ?>
                        <button type="button" class="delete-plan-row button" data-row-id="<?php echo esc_attr($index); ?>"><?php esc_html_e('Delete', 'reordere-lite-subcriptions-for-woocommerce'); ?></button>
                    <?php endif; ?>
                </div>
                <?php
            }
        }
        ?>
    </div>

     <button type="button" class="add-more-plans button" data-variation-id="<?php echo esc_attr($variation->ID); ?>">Add More Plan</button>
    </div>
    <?php
}
add_action('woocommerce_product_after_variable_attributes', 'rorder_add_subscription_fields_to_variations', 10, 3);

/**
 * Save subscription fields for variations.
 *
 * @param int $variation_id The variation ID.
 */
function rorder_save_subscription_fields_for_variations($variation_id) {
    // Properly sanitize the enable_subscription input
    $enable_subscription = isset($_POST['enable_subscription'][$variation_id]) ? 'yes' : 'no';
    
    // Properly sanitize subscription_title with wp_unslash and sanitize_text_field
    $subscription_title = isset($_POST['subscription_title'][$variation_id]) ? 
        sanitize_text_field(wp_unslash($_POST['subscription_title'][$variation_id])) : '';
    
    // Properly sanitize discount_type with wp_unslash and sanitize_text_field
    $discount_type = isset($_POST['subscription_discount_type'][$variation_id]) ? 
        sanitize_text_field(wp_unslash($_POST['subscription_discount_type'][$variation_id])) : '';
    
    // Handle subscription_fields array with proper sanitization using map_deep
    $subscription_fields = isset($_POST['subscription_fields'][$variation_id]) ? 
        map_deep(wp_unslash($_POST['subscription_fields'][$variation_id]), 'sanitize_text_field') : [];

    // Sanitize each field in the subscription_fields array
    $plans = [];
    foreach ($subscription_fields as $field) {
        $plans[] = [
            'name'     => sanitize_text_field($field['name']),
            'period'   => sanitize_text_field($field['period']),
            'interval' => intval($field['interval']),
            'price'    => floatval($field['price']),
        ];
    }

    update_post_meta($variation_id, '_enable_subscription', $enable_subscription);
    update_post_meta($variation_id, '_subscription_title', $subscription_title);
    update_post_meta($variation_id, '_subscription_discount_type', $discount_type);
    update_post_meta($variation_id, '_subscription_plans', $plans);
}

/**
 * Calculate the final price based on discount type.
 *
 * @param float $regular_price The regular price.
 * @param string $discount_type The discount type.
 * @param float $total_price The total price.
 * @return float The final price.
 */
function rorder_calculate_final_price($regular_price, $discount_type, $total_price) {
    if ($discount_type === 'flat') {
        return $total_price; // Use the flat rate directly
    } elseif ($discount_type === 'percentage') {
        return max(0, $regular_price - ($regular_price * ($total_price / 100))); // Subtract percentage discount
    } elseif ($discount_type === 'amount_off') {
        return max(0, $regular_price - $total_price); // Subtract fixed amount
    }

    return $regular_price; // Default to regular price
}

/**
 * Enqueue custom admin scripts for variations.
 *
 * @param string $hook The current admin page.
 */
function rorder_enqueue_variation_scripts($hook) {
    if ($hook !== 'post.php' && $hook !== 'post-new.php') {
        return;
    }
    if (get_post_type() !== 'product') {
        return;
    }

    wp_enqueue_script(
        'subscription-products-admin',
        plugin_dir_url( dirname( __FILE__ ) ) . 'js/subscription-products-admin.js',
        array('jquery'),
        '1.0.0',
        true
    );
    
    wp_localize_script('subscription-products-admin', 'customData', array(
        'deleteButtonText' => esc_html__('Delete', 'reordere-lite-subcriptions-for-woocommerce'),
    ));
}
// Remove this duplicate action to avoid conflicts with rorder_enqueue_custom_scripts
// add_action('admin_enqueue_scripts', 'rorder_enqueue_variation_scripts');
?>
