<?php
/*
 * Template Name: Subscription Settings
 *
 * @package TS_Subscription
 */

 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Styles and scripts are now enqueued properly in the main admin class - no need to enqueue here

// Handle form submission to save settings.
if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_subscription_settings'])) {
    // Verify nonce with proper sanitization
    $nonce = isset($_POST['subscription_settings_nonce']) ? sanitize_text_field(wp_unslash($_POST['subscription_settings_nonce'])) : '';
    if (!wp_verify_nonce($nonce, 'subscription_settings_nonce')) {
        echo '<div class="error"><p>' . esc_html__('Security check failed. Please try again.', 'reordere-lite-subcriptions-for-woocommerce') . '</p></div>';
    } else {
        // Sanitize and save display settings
        $one_time_title = isset($_POST['one_time_title']) ? sanitize_text_field(wp_unslash($_POST['one_time_title'])) : '';
        $subscription_title = isset($_POST['subscription_title']) ? sanitize_text_field(wp_unslash($_POST['subscription_title'])) : '';
        $subscribe_button = isset($_POST['subscribe_button_text']) ? sanitize_text_field(wp_unslash($_POST['subscribe_button_text'])) : '';
        $select_plan_view = isset($_POST['select_plan_view']) ? sanitize_text_field(wp_unslash($_POST['select_plan_view'])) : '';
        
        // Save display settings
        update_option('rorder_one_time_purchase_title', $one_time_title);
        update_option('rorder_subscription_product_title', $subscription_title);
        update_option('rorder_subscribe_button_text', $subscribe_button);
        update_option('rorder_selected_plan_view', $select_plan_view);

        // Process the payment settings with proper sanitization
        $retry_count = isset($_POST['retry_count']) ? absint($_POST['retry_count']) : 3;
        $retry_interval = isset($_POST['retry_interval']) ? absint($_POST['retry_interval']) : 1;
        $retry_interval_unit = isset($_POST['retry_interval_unit']) ? sanitize_text_field(wp_unslash($_POST['retry_interval_unit'])) : 'day';
        
        // Save payment settings
        update_option('rorder_subscription_retry_count', $retry_count);
        update_option('rorder_subscription_retry_interval', $retry_interval);
        update_option('rorder_subscription_retry_interval_unit', $retry_interval_unit);
        
        echo '<div class="updated"><p>' . esc_html__('Settings saved successfully!', 'reordere-lite-subcriptions-for-woocommerce') . '</p></div>';
    }
}

// Get current saved titles for display settings
$one_time_title = get_option('rorder_one_time_purchase_title', 'Default One-Time Purchase');
$subscription_title = get_option('rorder_subscription_product_title', 'Default Subscription');
$subscribe_button = get_option('rorder_subscribe_button_text', 'Subscribe');
$select_plan_view = get_option('rorder_selected_plan_view', 'simple_view');
$selected_plan_view = get_option('rorder_selected_plan_view', 'simple_view');

// Get current settings for payment settings
$retry_count = get_option('rorder_subscription_retry_count', 3);
$retry_interval = get_option('rorder_subscription_retry_interval', 1);
$retry_interval_unit = get_option('rorder_subscription_retry_interval_unit', 'day');

?>

<section class="container settings-section-subscription">
    <form action="" method="POST">
        <?php wp_nonce_field('subscription_settings_nonce', 'subscription_settings_nonce'); ?>
        <div class="row">
            <div class="col-md-6">
                <label style="font-size: 20px;font-weight: 500;margin-bottom: 15px;"><?php esc_html_e('Display Settings', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                
                <div class="form-group">
                    <label for="select_plan_view"><?php esc_html_e('Select Plan View', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <select name="select_plan_view" id="select_plan_view" class="form-control">
                        <option value="simple_view" <?php selected($selected_plan_view, 'simple_view'); ?>><?php esc_html_e('Simple View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="card_view" <?php selected($selected_plan_view, 'card_view'); ?>><?php esc_html_e('Card View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="select_view" <?php selected($selected_plan_view, 'select_view'); ?>><?php esc_html_e('Select View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="list_view" <?php selected($selected_plan_view, 'list_view'); ?>><?php esc_html_e('List View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="adv_list_view" <?php selected($selected_plan_view, 'adv_list_view'); ?>><?php esc_html_e('Advanced List View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="drawer_view" <?php selected($selected_plan_view, 'drawer_view'); ?>><?php esc_html_e('Drawer View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                        <option value="popup_view" <?php selected($selected_plan_view, 'popup_view'); ?>><?php esc_html_e('Popup View', 'reordere-lite-subcriptions-for-woocommerce'); ?></option>
                    </select>
                    <span class="description"><?php esc_html_e('This will change the view of select plan in frontend.', 'reordere-lite-subcriptions-for-woocommerce'); ?></span>
                </div>
                
                <div class="form-group">
                    <label for="one_time_title"><?php esc_html_e('One-Time Purchase Title', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="text" name="one_time_title" id="one_time_title" class="form-control" value="<?php echo esc_attr($one_time_title); ?>">
                    <span class="description"><?php esc_html_e('This title will show for one-time purchases.', 'reordere-lite-subcriptions-for-woocommerce'); ?></span>
                </div>
                
                <div class="form-group">
                    <label for="subscription_title"><?php esc_html_e('Subscription Title', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="text" name="subscription_title" id="subscription_title" class="form-control" value="<?php echo esc_attr($subscription_title); ?>" required>
                    <span class="description"><?php esc_html_e('This title will show for subscription products.', 'reordere-lite-subcriptions-for-woocommerce'); ?></span>
                </div>
                
                <div class="form-group">
                    <label for="subscribe_button_text"><?php esc_html_e('Subscribe Button Text', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                    <input type="text" name="subscribe_button_text" id="subscribe_button_text" class="form-control" value="<?php echo esc_attr($subscribe_button); ?>">
                    <span class="description"><?php esc_html_e('This text will change the text of subscribe button.', 'reordere-lite-subcriptions-for-woocommerce'); ?></span>
                </div>
            </div>
            
            <div class="col-md-6">
                <label style="font-size: 20px;margin-bottom:10px;font-weight:500;"><?php esc_html_e('Views Preview', 'reordere-lite-subcriptions-for-woocommerce'); ?></label>
                <span class="description" style="margin-bottom: 15px;display:block;"><?php esc_html_e('This will show the preview of selected plan view.', 'reordere-lite-subcriptions-for-woocommerce'); ?></span>
                
                <!-- Simple View (Horizontal List View) -->
                <div id="preview-box" class="preview-box" style="width: 50%;">
                    <ul class="subscription-plans subscription-simple_view_wrapper">
                        <li class="subscription-plan subscription-simple_view_card">
                            <label class="subscription-plan-card" style="text-align: center;">
                                <h3><?php esc_html_e( 'Buy and go', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$1000</div>
                                <div class="final-price">$999</div>
                                <div class="description"><?php esc_html_e( 'One-time buy', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                        <li class="subscription-plan subscription-simple_view_card">
                            <label class="subscription-plan-card" style="text-align: center;">
                                <h3><?php esc_html_e( 'Every 1 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$1000</div>
                                <div class="final-price">$999</div>
                                <div class="discount-label"><?php esc_html_e( '10% off', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                        <li class="subscription-plan subscription-simple_view_card">
                            <label class="subscription-plan-card" style="text-align: center;">
                                <h3><?php esc_html_e( 'Every 3 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$3000</div>
                                <div class="final-price">$2700</div>
                                <div class="discount-label"><?php esc_html_e( '10% off', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                    </ul>
                </div>

                <!-- Card View -->
                <div id="preview-box-2" class="preview-box-2">
                    <ul class="subscription-plans subscription-card_view_wrapper">
                        <li class="subscription-plan subscription-plan_card_view">
                            <label class="subscription-plan-card">
                                <h3><?php esc_html_e( 'Buy and go', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$1000</div>
                                <div class="final-price">$999</div>
                                <div class="description"><?php esc_html_e( 'One-time buy', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                        <li class="subscription-plan subscription-plan_card_view">
                            <label class="subscription-plan-card">
                                <h3><?php esc_html_e( 'Every 1 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$1000</div>
                                <div class="final-price">$999</div>
                                <div class="discount-label"><?php esc_html_e( '10% off', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                        <li class="subscription-plan subscription-plan_card_view">
                            <label class="subscription-plan-card">
                                <h3><?php esc_html_e( 'Every 3 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h3>
                                <div class="discount">$3000</div>
                                <div class="final-price">$2700</div>
                                <div class="discount-label"><?php esc_html_e( '10% off', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                            </label>
                        </li>
                    </ul>
                </div>
                
                <!-- Select View -->
                <div class="preview-box-3" id="preview-box-3">
                    <div class="select-plan">
                        <select name="plans" id="plans" class="form-control">
                            <option value="1"><?php esc_html_e( 'Every 1 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></option>
                            <option value="2"><?php esc_html_e( 'Every 3 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></option>
                            <option value="3"><?php esc_html_e( 'Every 6 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></option>
                        </select>
                    </div>
                </div>
                
                <!-- List View -->
                <div class="preview-box-4" id="preview-box-4">
                    <div id="subscription-product-section" class="subscription-fields-wrapper variable_subscription_wrapper subscription-list_view_wrapper">                
                        <div class="subscription-plan_list_view">
                            <ul class="subscription-plans">
                                <li class="subscription-plan">
                                    <input type="radio" name="selected_subscription" id="one_time_purchase_inherit_view" class="inherit_radio" value="one-time-purchase">
                                    <label for="one_time_purchase">
                                        <div class="plan-title"><?php esc_html_e( 'Default One-Time Purchase', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                                        <div class="plan-price"><span class="amount"><bdi><span class="currencySymbol">₹</span>400.00</bdi></span></div>
                                    </label>
                                </li>
                                <li class="subscription-plan">
                                    <input type="radio" name="selected_subscription" id="subscription_plan_inherit" value="1" data-price="320">
                                    <label for="subscription_plan_1">
                                        <div class="plan-title"><?php esc_html_e( 'Monthly Plan', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                                        <div class="plan-price"><span class="amount"><span class="currencySymbol">₹</span>320.00</span></div>
                                    </label>
                                </li>
                                <li class="subscription-plan">
                                    <input type="radio" name="selected_subscription" id="subscription_plan_inherit_2" value="2" data-price="280">
                                    <label for="subscription_plan_2">
                                        <div class="plan-title"><?php esc_html_e( 'Yearly Plan', 'reordere-lite-subcriptions-for-woocommerce' ); ?></div>
                                        <div class="plan-price"><span class="amount"><span class="currencySymbol">₹</span>280.00</span></div>
                                    </label>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <!-- Advanced List View -->
                <div class="preview-box-5" id="preview-box-5">
                    <div class="adv_list_view_delivery-frequency">
                        <div class="adv_list_frequency-option">
                            <div class="adv_list_ckbtn-text">
                                <input type="radio" name="adv_list_delivery_frequency" id="buy-go-adv" value="buy_go">
                                <label for="buy-go-adv"><?php esc_html_e( 'Buy and go!', 'reordere-lite-subcriptions-for-woocommerce' ); ?></label>
                            </div>
                            <div class="adv_list_ckbtn-price">
                                <label for="buy-go-price">$100</label>
                            </div>
                        </div>
                        <div class="adv_list_frequency-option">
                            <div class="adv_list_ckbtn-text">
                                <input type="radio" name="adv_list_delivery_frequency" id="subscribe-save-adv" value="subscribe_save" checked>
                                <label for="subscribe-save-adv"><?php esc_html_e( 'Subscription & Save', 'reordere-lite-subcriptions-for-woocommerce' ); ?></label>
                            </div>
                            <div class="adv_list_ckbtn-price">
                                <label for="save-price">$10</label>
                            </div>
                        </div>
                        <div class="adv_list_delivery-frequency">
                            <div class="adv_list_frequency-option">
                                <div class="adv_list_ckbtn-text">
                                    <input type="radio" name="delivery_frequency_adv" id="every_1_month" value="every_1_month" checked>
                                    <label for="every_1_month"><?php esc_html_e( 'Every 1 Month', 'reordere-lite-subcriptions-for-woocommerce' ); ?></label>
                                </div>
                                <div class="adv_list_ckbtn-price">
                                    <label for="every_1_month_price">$90</label>
                                </div>
                            </div>
                            <div class="adv_list_frequency-option">
                                <div class="adv_list_ckbtn-text">
                                    <input type="radio" name="delivery_frequency_adv" id="every_3_months" value="every_3_months">
                                    <label for="every_3_months"><?php esc_html_e( 'Every 3 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></label>
                                </div>
                                <div class="adv_list_ckbtn-price">
                                    <label for="every_3_months_price">$80</label>
                                </div>
                            </div>
                            <div class="adv_list_frequency-option">
                                <div class="adv_list_ckbtn-text">
                                    <input type="radio" name="delivery_frequency_adv" id="every_6_months" value="every_6_months">
                                    <label for="every_6_months"><?php esc_html_e( 'Every 6 Month(s)', 'reordere-lite-subcriptions-for-woocommerce' ); ?></label>
                                </div>
                                <div class="adv_list_ckbtn-price">
                                    <label for="every_6_months_price">$70</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Drawer View -->
                <div class="preview-box-6" id="preview-box-6">
                    <div class="drawer_view_wrapper">
                        <h6><?php esc_html_e( 'No preview available for the drawer view.', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h6>
                    </div>
                </div>
                
                <!-- Popup View -->
                <div class="preview-box-7" id="preview-box-7">
                    <div class="popup_view_wrapper">
                        <h6><?php esc_html_e( 'No preview available for the popup view.', 'reordere-lite-subcriptions-for-woocommerce' ); ?></h6>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Save Button -->
        <div class="form-group" style="margin-top: 30px;">
            <button type="submit" name="save_subscription_settings" class="save-btn">
                <?php esc_html_e('Save Settings', 'reordere-lite-subcriptions-for-woocommerce'); ?>
            </button>
        </div>
    </form>
</section>

