(function($) {
    'use strict';

    $(document).ready(function() {
        // Toggle subscription fields visibility when the "Enable Subscription" checkbox changes
        $('.enable_subscription').change(function() {
            if ($(this).is(':checked')) {
                $('#subscription-fields-container').show();
                $('#subscription-fields-split').show();
            } else {
                $('#subscription-fields-container').hide();
                $('#subscription-fields-split').hide();
            }
        });

        // Initially hide the subscription fields if the checkbox is unchecked
        if (!$('.enable_subscription').is(':checked')) {
            $('#subscription-fields-container').hide();
            $('#subscription-fields-split').hide();
        }

        // Add more subscription fields when the "Add More" button is clicked
        $('#add-more-fields').click(function() {
            const rowCount = $('.subscription-field-row').length + 1;
            const newRow = $('.subscription-field-row').first().clone();

            // Update the IDs and names of all input elements
            newRow.attr('data-row-id', rowCount);
            newRow.find('input, select').each(function() {
                const fieldName = $(this).attr('name');
                if (fieldName) {
                    const newFieldName = fieldName.replace(/\[\d+\]/, '[' + rowCount + ']');
                    $(this).attr('name', newFieldName);
                }
                
                const fieldId = $(this).attr('id');
                if (fieldId) {
                    const newFieldId = fieldId.replace(/\_\d+$/, '_' + rowCount);
                    $(this).attr('id', newFieldId);
                }
                
                // Clear the values
                if (!$(this).hasClass('total_price')) {
                    $(this).val('');
                }
            });

            // Make the delete button visible
            newRow.find('.delete-field').css('display', 'block');

            // Add event listener to the delete button
            newRow.find('.delete-field').click(function() {
                $(this).closest('.subscription-field-row').remove();
            });

            // Append the new row
            $('#subscription-fields').append(newRow);
        });

        // Delete subscription fields when the "Delete" button is clicked
        $('.delete-field').click(function() {
            $(this).closest('.subscription-field-row').remove();
        });

        // Handle dynamic pricing update based on discount type
        $('input[name="subscription_discount_type"]').change(function() {
            updatePrices();
        });
        
        $('.subscription-price').on('input', function() {
            updatePrices();
        });
        
        // Update prices on page load
        updatePrices();
        
        function updatePrices() {
            const discountType = $('input[name="subscription_discount_type"]:checked').val();
            const regularPrice = parseFloat($('#_regular_price').val()) || 0;
            
            $('.subscription-price').each(function() {
                const rowId = $(this).closest('.subscription-field-row').attr('data-row-id');
                const subscriptionPrice = parseFloat($(this).val()) || 0;
                let finalPrice = subscriptionPrice;
                
                if (discountType === 'percentage') {
                    finalPrice = regularPrice - (regularPrice * (subscriptionPrice / 100));
                } else if (discountType === 'amount_off') {
                    finalPrice = Math.max(0, regularPrice - subscriptionPrice);
                }
                
                $(`#total_price_${rowId}`).val(finalPrice.toFixed(2));
            });
        }
        
        // Handle variations
        $('.add-more-plans').click(function() {
            const variationId = $(this).data('variation-id');
            const container = $(`.subscription-plan-fields-container-${variationId}`);
            const rowCount = container.find('.subscription-plan-row').length;
            const newRow = container.find('.subscription-plan-row').first().clone();
            
            // Update field names with new index
            newRow.find('input, select').each(function() {
                const name = $(this).attr('name');
                if (name) {
                    const newName = name.replace(/\[\d+\](?=\[)/, `[${rowCount}]`);
                    $(this).attr('name', newName);
                }
                if (!$(this).attr('type') || $(this).attr('type') !== 'hidden') {
                    $(this).val(''); // Clear values except for hidden fields
                }
            });
            
            // Add delete button if it doesn't exist
            if (newRow.find('.delete-plan-row').length === 0) {
                newRow.append(`<button type="button" class="delete-plan-row button" data-row-id="${rowCount}">${customData.deleteButtonText}</button>`);
            }
            
            container.append(newRow);
            
            // Add event handler for delete button
            newRow.find('.delete-plan-row').click(function() {
                $(this).closest('.subscription-plan-row').remove();
            });
        });
        
        // Initialize delete buttons for existing rows
        $(document).on('click', '.delete-plan-row', function() {
            $(this).closest('.subscription-plan-row').remove();
        });
    });
})(jQuery);





