jQuery(document).ready(function($) {
    'use strict';
    
    // Get the selected plan view from WordPress options (passed via localization)
    var selectedPlanView = typeof bulkSubscriptionData !== 'undefined' ? bulkSubscriptionData.selected_plan_view : 'simple_view';
    
    // Initialize Select2 for products dropdown
    $('#subscription_products').select2({
        placeholder: 'Select products...',
        allowClear: true,
        width: '100%'
    });
    
    // Initialize Select2 for interval dropdowns
    $('.form-control').each(function() {
        if ($(this).is('select') && !$(this).hasClass('select2-hidden-accessible')) {
            $(this).select2({
                minimumResultsForSearch: -1,
                width: '100%'
            });
        }
    });
    
    // Update preview to show WooCommerce product single page replica
    function updatePreview() {
        const title = $('#subscription_title').val();
        const selectedProducts = $('#subscription_products').select2('data');
        const discountType = $('input[name="subscription_discount_type"]:checked').val();
        const plans = [];
        
        // Collect all plan data
        $('.subscription-field-row').each(function() {
            const planName = $(this).find('input[name*="_subs_title"]').val();
            const planPeriod = $(this).find('input[name*="_subs_period"]').val();
            const planInterval = $(this).find('select[name*="_subs_period_interval"]').val();
            const planPrice = $(this).find('input[name*="_subs_price_field"]').val();
            
            if (planName && planPeriod && planPrice) {
                plans.push({
                    name: planName,
                    period: planPeriod,
                    interval: planInterval || 'month',
                    price: planPrice
                });
            }
        });
        
        // Show/hide preview content
        if (selectedProducts.length === 0 && plans.length === 0) {
            $('.preview-empty').show();
            $('.preview-content').hide();
            return;
        }
        
        $('.preview-empty').hide();
        $('.preview-content').show();
        
        // Get first product data for preview
        const firstProductId = selectedProducts.length > 0 ? selectedProducts[0].id : null;
        const productName = selectedProducts.length > 0 ? selectedProducts[0].text : 'Sample Product';
        
        // Build WooCommerce product page with two-column layout
        let previewHTML = '<div class="preview-product-page">';
        
        // LEFT COLUMN - Product Image
        // Get the dummy image path
        const pluginUrl = typeof bulkSubscriptionData !== 'undefined' ? bulkSubscriptionData.plugin_url : '';
        const dummyImageUrl = pluginUrl + 'assets/images/simple-black-t-shirt-worn-by-man.jpg';
        
        previewHTML += '<div class="preview-product-images">';
        if (firstProductId) {
            previewHTML += '<div class="preview-product-image" data-product-id="' + firstProductId + '" data-dummy-image="' + dummyImageUrl + '"><img src="' + dummyImageUrl + '" alt="Product"></div>';
        } else {
            previewHTML += '<div class="preview-product-image"><img src="' + dummyImageUrl + '" alt="Product"></div>';
        }
        previewHTML += '</div>'; // End left column
        
        // RIGHT COLUMN - Product Summary
        previewHTML += '<div class="preview-product-summary">';
        
        // Product title
        previewHTML += '<h1 class="preview-product-title">' + productName + '</h1>';
        
        // Product price (fetch real price if available)
        if (firstProductId) {
            const productOption = $('#subscription_products option[value="' + firstProductId + '"]');
            const regularPrice = productOption.data('regular-price');
            if (regularPrice) {
                previewHTML += '<p class="preview-product-price"><span class="amount">$' + parseFloat(regularPrice).toFixed(2) + '</span></p>';
            } else {
                previewHTML += '<p class="preview-product-price"><span class="amount">$99.00</span></p>';
            }
        } else {
            previewHTML += '<p class="preview-product-price"><span class="amount">$99.00</span></p>';
        }
        
        // Stock status
        previewHTML += '<p class="preview-product-stock">In stock</p>';
        
        // Subscription plans section - ALWAYS use list view in preview for better fit
        if (plans.length > 0) {
            const subscriptionTitle = title || 'Subscription Plans';
            previewHTML += '<h4 class="subscription-title">' + subscriptionTitle + ':</h4>';
            
            // Force list view for preview (better space utilization)
            previewHTML += renderPlansBasedOnView(plans, 'list_view', discountType, firstProductId);
        }
        
        // Add to cart button - WooCommerce style
        const buttonText = typeof bulkSubscriptionData !== 'undefined' ? bulkSubscriptionData.subscribe_button_text : 'Subscribe';
        previewHTML += '<div class="preview-add-to-cart">';
        previewHTML += '<button type="button" class="single_add_to_cart_button button alt">' + buttonText + '</button>';
        previewHTML += '</div>';
        
        previewHTML += '</div>'; // End product summary (right column)
        previewHTML += '</div>'; // End product page
        
        $('.preview-content').html(previewHTML);
        
        // Try to fetch real product image, keep dummy if fails
        if (firstProductId) {
            fetchProductImage(firstProductId, function(imageUrl) {
                const $imageContainer = $('.preview-product-image[data-product-id="' + firstProductId + '"]');
                const dummyUrl = $imageContainer.attr('data-dummy-image');
                
                if (imageUrl && imageUrl !== '') {
                    // Use real product image if available
                    $imageContainer.html('<img src="' + imageUrl + '" alt="' + productName + '">');
                } else {
                    // Keep dummy image if no real image found
                    $imageContainer.html('<img src="' + dummyUrl + '" alt="Product">');
                }
            });
        }
    }
    
    // Fetch product image via AJAX
    function fetchProductImage(productId, callback) {
        $.ajax({
            url: ajaxurl || '/wp-admin/admin-ajax.php',
            type: 'POST',
            data: {
                action: 'get_product_image',
                product_id: productId
            },
            success: function(response) {
                if (response.success && response.data.image_url) {
                    callback(response.data.image_url);
                } else {
                    callback(null);
                }
            },
            error: function() {
                callback(null);
            }
        });
    }
    
    function renderPlansBasedOnView(plans, viewType, discountType, productId) {
        let html = '';
        const regularPrice = 99.00; // Default regular price for display
        const oneTimePurchaseTitle = typeof bulkSubscriptionData !== 'undefined' ? bulkSubscriptionData.one_time_purchase_title : 'One Time Purchase';
        
        switch(viewType) {
            case 'simple_view':
                html += '<div class="subscription-fields-wrapper variable_subscription_wrapper subscription-simple_view_wrapper">';
                // Add one-time purchase option
                html += '<div class="subscription-plan subscription-simple_view_card">';
                html += '<div class="">';
                html += '<label for="one-time-purchase-preview" class="subscription-plan-card">';
                html += '<h3>' + oneTimePurchaseTitle + '</h3>';
                html += '<div class="discount">$' + regularPrice.toFixed(2) + '</div>';
                html += '<div class="product-price">$' + regularPrice.toFixed(2) + '</div>';
                html += '</label>';
                html += '<input type="radio" id="one-time-purchase-preview" name="selected_subscription" value="one-time-purchase" checked>';
                html += '</div></div>';
                
                // Add subscription plans
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' - ' + plan.period + ' ' + getIntervalLabel(plan.interval);
                    html += '<div class="subscription-plan subscription-simple_view_card">';
                    html += '<label for="plan-preview-' + index + '" class="subscription-plan-card">';
                    html += '<h3>' + finalTitle + '</h3>';
                    html += '<div class="discount">$' + regularPrice.toFixed(2) + '</div>';
                    html += '<div class="product-price">$' + parseFloat(plan.price).toFixed(2) + '</div>';
                    html += '</label>';
                    html += '<input type="radio" id="plan-preview-' + index + '" name="selected_subscription" value="' + index + '">';
                    html += '</div>';
                });
                html += '</div>';
                break;
                
            case 'card_view':
                html += '<div class="subscription-fields-wrapper variable_subscription_wrapper subscription-card_view_wrapper">';
                // Add one-time purchase option
                html += '<div class="subscription-plan subscription-plan_card_view">';
                html += '<div>';
                html += '<label for="one-time-purchase-preview" class="subscription-plan-card">';
                html += '<h3>' + oneTimePurchaseTitle + '</h3>';
                html += '<div class="discount">$' + regularPrice.toFixed(2) + '</div>';
                html += '<div class="product-price">$' + regularPrice.toFixed(2) + '</div>';
                html += '</label>';
                html += '<input type="radio" id="one-time-purchase-preview" name="selected_subscription" value="one-time-purchase" checked>';
                html += '<p>One-time buy</p>';
                html += '</div></div>';
                
                // Add subscription plans
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' - ' + plan.period + ' ' + getIntervalLabel(plan.interval);
                    html += '<div class="subscription-plan subscription-plan_card_view">';
                    html += '<div>';
                    html += '<label for="plan-preview-' + index + '" class="subscription-plan-card">';
                    html += '<h3>' + finalTitle + '</h3>';
                    html += '<div class="discount">$' + regularPrice.toFixed(2) + '</div>';
                    html += '<div class="product-price">$' + parseFloat(plan.price).toFixed(2) + '</div>';
                    html += '</label>';
                    html += '<input type="radio" id="plan-preview-' + index + '" name="selected_subscription" value="' + index + '">';
                    html += '</div></div>';
                });
                html += '</div>';
                break;
                
            case 'list_view':
                html += '<div class="subscription-list_view_wrapper">';
                html += '<ul class="subscription-plans">';
                // One-time purchase
                html += '<li class="subscription-plan">';
                html += '<input type="radio" name="selected_subscription" id="one_time_purchase_preview" value="one-time-purchase" checked>';
                html += '<label for="one_time_purchase_preview">';
                html += '<div class="plan-title">' + oneTimePurchaseTitle + '</div>';
                html += '<div class="plan-price">$' + regularPrice.toFixed(2) + '</div>';
                html += '</label></li>';
                
                // Subscription plans
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' (' + plan.period + ' ' + getIntervalLabel(plan.interval) + ')';
                    html += '<li class="subscription-plan">';
                    html += '<input type="radio" name="selected_subscription" id="plan-preview-' + index + '" value="' + index + '">';
                    html += '<label for="plan-preview-' + index + '">';
                    html += '<div class="plan-title">' + finalTitle + '</div>';
                    html += '<div class="plan-price">$' + parseFloat(plan.price).toFixed(2) + '</div>';
                    html += '</label></li>';
                });
                html += '</ul></div>';
                break;
                
            case 'select_view':
                html += '<div class="preview-box-3 subscription-plan_select_view">';
                html += '<ul class="subscription-plans">';
                html += '<div class="select-plan_adv_view">';
                html += '<select name="selected_subscription_plan" class="form-control">';
                html += '<option value="">Select a plan</option>';
                html += '<option value="one-time-purchase">' + oneTimePurchaseTitle + ' - $' + regularPrice.toFixed(2) + '</option>';
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' - ' + plan.period + ' ' + getIntervalLabel(plan.interval);
                    html += '<option value="' + index + '">' + finalTitle + ' - $' + parseFloat(plan.price).toFixed(2) + '</option>';
                });
                html += '</select></div></ul></div>';
                break;
                
            case 'adv_list_view':
                html += '<div class="preview-box-5 subscription-plan_adv_list_view">';
                html += '<div class="adv_list_view_delivery-frequency">';
                // One-time purchase
                html += '<div class="adv_list_frequency-option">';
                html += '<div class="adv_list_ckbtn-text">';
                html += '<input type="radio" name="selected_subscription" id="one_time_purchase_preview" value="one-time-purchase" checked>';
                html += '<label for="one_time_purchase_preview"><div class="plan-title">' + oneTimePurchaseTitle + '</div></label>';
                html += '</div>';
                html += '<div class="adv_list_ckbtn-price"><div class="plan-price">$' + regularPrice.toFixed(2) + '</div></div>';
                html += '</div>';
                
                // Subscribe & Save header
                html += '<div class="adv_list_frequency-option">';
                html += '<div class="adv_list_ckbtn-text">';
                html += '<input type="radio" name="adv_list_delivery_frequency" id="subscribe-save-preview" value="subscribe_save">';
                html += '<label for="subscribe-save-preview">Subscription & Save</label>';
                html += '</div><div class="adv_list_ckbtn-price"></div></div>';
                
                // Plans
                html += '<div class="adv_list_delivery-frequency">';
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' - ' + plan.period + ' ' + getIntervalLabel(plan.interval);
                    html += '<div class="adv_list_frequency-option">';
                    html += '<div class="adv_list_ckbtn-text">';
                    html += '<input type="radio" name="selected_subscription" id="plan-preview-' + index + '" value="' + index + '">';
                    html += '<label for="plan-preview-' + index + '"><div class="plan-title">' + finalTitle + '</div></label>';
                    html += '</div>';
                    html += '<div class="adv_list_ckbtn-price"><div class="plan-price">$' + parseFloat(plan.price).toFixed(2) + '</div></div>';
                    html += '</div>';
                });
                html += '</div></div></div>';
                break;
                
            default:
                // Fallback to simple view
                html += '<div class="subscription-fields-wrapper variable_subscription_wrapper subscription-simple_view_wrapper">';
                plans.forEach(function(plan, index) {
                    const finalTitle = plan.name + ' - ' + plan.period + ' ' + getIntervalLabel(plan.interval);
                    html += '<div class="subscription-plan subscription-simple_view_card">';
                    html += '<label for="plan-preview-' + index + '" class="subscription-plan-card">';
                    html += '<h3>' + finalTitle + '</h3>';
                    html += '<div class="product-price">$' + parseFloat(plan.price).toFixed(2) + '</div>';
                    html += '</label>';
                    html += '<input type="radio" id="plan-preview-' + index + '" name="selected_subscription" value="' + index + '">';
                    html += '</div>';
                });
                html += '</div>';
        }
        
        return html;
    }
    
    function getIntervalLabel(interval) {
        const labels = {
            'day': 'Day(s)',
            'week': 'Week(s)',
            'month': 'Month(s)',
            'year': 'Year(s)'
        };
        return labels[interval] || interval;
    }
    
    // Bind change events
    $('#subscription_title, input[name="subscription_discount_type"]').on('input change', updatePreview);
    $('#subscription_products').on('change', updatePreview);
    
    // Update preview when plan fields change
    $(document).on('input change', '.subscription-field-row input, .subscription-field-row select', updatePreview);
    
    // Add more fields functionality
    let fieldCount = 1;
    $('#add-more-fields').on('click', function() {
        const newRow = `
            <div class="form-row subscription-field-row" data-row-id="${fieldCount}">
                <div class="form-group">
                    <label for="_subs_title_${fieldCount}">Plan Name</label>
                    <input type="text" name="subscription_fields[${fieldCount}][_subs_title]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="_subs_period_${fieldCount}">Plan Period</label>
                    <input type="number" name="subscription_fields[${fieldCount}][_subs_period]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="_subs_period_interval_${fieldCount}">Plan Interval</label>
                    <select name="subscription_fields[${fieldCount}][_subs_period_interval]" class="form-control">
                        <option value="day">Day(s)</option>
                        <option value="week">Week(s)</option>
                        <option value="month">Month(s)</option>
                        <option value="year">Year(s)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="_subs_price_${fieldCount}">Plan Price</label>
                    <input type="number" name="subscription_fields[${fieldCount}][_subs_price_field]" class="form-control bulk_price_change">
                </div>
                <div class="form-group">
                    <button type="button" class="btn btn-danger delete-field"><i class="dashicons dashicons-trash"></i> Delete</button>
                </div>
                <input type="hidden" class="total_price" name="subscription_fields[${fieldCount}][_subs_price]" value="">
            </div>
        `;
        
        $('#subscription-fields').append(newRow);
        
        // Initialize Select2 for the new interval dropdown
        $('#subscription-fields .subscription-field-row:last-child select').select2({
            minimumResultsForSearch: -1,
            width: '100%'
        });
        
        // Show all delete buttons if more than one row
        if ($('.subscription-field-row').length > 1) {
            $('.delete-field').show();
        }
        
        fieldCount++;
        updatePreview();
    });
    
    // Delete field functionality
    $(document).on('click', '.delete-field', function() {
        if ($('.subscription-field-row').length > 1) {
            $(this).closest('.subscription-field-row').fadeOut(300, function() {
                $(this).remove();
                
                // Hide delete buttons if only one row remains
                if ($('.subscription-field-row').length === 1) {
                    $('.delete-field').hide();
                }
                
                updatePreview();
            });
        }
    });
    
    // Calculate total price based on discount type
    $(document).on('input', '.bulk_price_change', function() {
        const row = $(this).closest('.subscription-field-row');
        const basePrice = parseFloat($(this).val()) || 0;
        const discountType = $('input[name="subscription_discount_type"]:checked').val();
        
        let finalPrice = basePrice;
        
        // You can add discount calculation logic here if needed
        // For now, just set the same price
        row.find('.total_price').val(finalPrice.toFixed(2));
        
        updatePreview();
    });
    
    // Form validation
    $('#save-bulk-subscription').on('click', function(e) {
        let isValid = true;
        let errorMessage = '';
        
        // Check subscription title
        if (!$('#subscription_title').val().trim()) {
            isValid = false;
            errorMessage = 'Please enter a subscription title.';
        }
        
        // Check if products are selected
        if ($('#subscription_products').val().length === 0) {
            isValid = false;
            errorMessage = 'Please select at least one product.';
        }
        
        // Check if discount type is selected
        if (!$('input[name="subscription_discount_type"]:checked').val()) {
            isValid = false;
            errorMessage = 'Please select a discount type.';
        }
        
        // Check if at least one plan exists with data
        let hasValidPlan = false;
        $('.subscription-field-row').each(function() {
            const planName = $(this).find('input[name*="_subs_title"]').val();
            const planPeriod = $(this).find('input[name*="_subs_period"]').val();
            const planPrice = $(this).find('input[name*="_subs_price_field"]').val();
            
            if (planName && planPeriod && planPrice) {
                hasValidPlan = true;
                return false; // break
            }
        });
        
        if (!hasValidPlan) {
            isValid = false;
            errorMessage = 'Please add at least one complete subscription plan.';
        }
        
        if (!isValid) {
            e.preventDefault();
            alert(errorMessage);
            return false;
        }
        
        // Show loading state
        $(this).closest('form').addClass('form-loading');
    });
    
    // Initial preview update
    updatePreview();
    
    // Smooth scroll to errors
    if ($('.bulk-subscription-message.error').length) {
        $('html, body').animate({
            scrollTop: $('.bulk-subscription-message.error').offset().top - 100
        }, 500);
    }
    
    // Auto-hide success messages after 5 seconds
    setTimeout(function() {
        $('.bulk-subscription-message.success').fadeOut(500);
    }, 5000);
});
