jQuery(document).ready(function($) {
    $('#add-more-fields').on('click', function() {
        var rowId = $('.subscription-field-row').length + 1;
        var newRow = $('.subscription-field-row:first').clone().attr('data-row-id', rowId);
        newRow.find('input, select').each(function() {
            var name = $(this).attr('name');
            name = name.replace(/\[\d+\]/, '[' + rowId + ']');
            $(this).attr('name', name).val('');
        });
        // Remove any delete buttons that might exist in the cloned row
        newRow.find('.delete-field').remove();
        $('#subscription-fields').append(newRow);
    });

});

jQuery(document).ready(function($) {
    // Optional: Update the displayed titles live while typing
    $('#one_time_title').on('input', function() {
        var customTitle = $(this).val();
        $('#one_time_title_display').text(customTitle);
    });

    $('#subscription_title').on('input', function() {
        var subscriptionTitle = $(this).val();
        $('#subscription_title_display').text(subscriptionTitle);
    });

    // Initially hide all preview boxes except for horizontal_list_view
    $('#preview-box-2').hide();
    $('#preview-box-3').hide();
    $('#preview-box-4').hide();
    $('#preview-box').show(); // Show the simple view by default

    // Show appropriate preview based on the selected plan view
    function rorder_showSelectedView(selectedView) {
        // Hide all preview boxes first
        $('#preview-box').hide();
        $('#preview-box-2').hide();
        $('#preview-box-3').hide();
        $('#preview-box-4').hide();
        $('#preview-box-5').hide();
        $('#preview-box-6').hide();
        $('#preview-box-7').hide();

        // Show the selected view
        if (selectedView === 'simple_view') {
            $('#preview-box').show();
        } else if (selectedView === 'card_view') {
            $('#preview-box-2').show();
        } else if (selectedView === 'select_view') {
            $('#preview-box-3').show();
        } else if (selectedView === 'list_view') {
            $('#preview-box-4').show();
        } else if (selectedView === 'adv_list_view') {
            $('#preview-box-5').show();
        } else if (selectedView === 'drawer_view') {
            $('#preview-box-6').show();
        } else if (selectedView === 'popup_view') {
            $('#preview-box-7').show();
        }
    }

    // Show the correct view based on the saved value
    var initialSelectedView = $('#select_plan_view').val() || 'horizontal_list_view'; // Default to horizontal_list_view
    rorder_showSelectedView(initialSelectedView); // Run on page load

    // Update view when the user changes the select box
    $('#select_plan_view').on('change', function() {
        var selectedView = $(this).val();
        rorder_showSelectedView(selectedView);
    });
});

    document.addEventListener('DOMContentLoaded', function () {
    const subscriptionRadio = document.getElementById('subscribe-save');
    const deliveryFrequency = document.querySelector('.delivery-frequency');
    const buyGoRadio = document.getElementById('buy-go');

    // Show the delivery frequency options when 'subscription & save' is selected
    subscriptionRadio.addEventListener('change', function () {
        if (subscriptionRadio.checked) {
            deliveryFrequency.style.display = 'block'; // Show delivery options
        }
    });

    // Hide the delivery frequency options when 'Buy and go!' is selected
    buyGoRadio.addEventListener('change', function () {
        if (buyGoRadio.checked) {
            deliveryFrequency.style.display = 'none'; // Hide delivery options
        }
    });
});

