<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$bemmClass = $this->attribute( "bemmClass" );
$embedURL  = $this->attribute( 'embedUrl.url' );
$id        = $this->attribute( 'fndryBlockId' );
$modalID   = "modal-$id";
$toggleID  = "modal-toggle-$id";
$label     = $this->attribute( 'label' );

if ( ! $embedURL && $this->getContext( 'postId' ) ) {
	$embedURL = get_permalink( $this->getContext( 'postId' ) );
}
?>
<a class="<?php $this->rootClasses() ?>" href="<?php echo esc_attr( $embedURL ) ?>" data-lity=""
   data-lity-target="<?php echo esc_attr( $embedURL ) ?>"
   data-modal="<?php echo esc_attr( $modalID ) ?>" id="<?php echo esc_attr( $toggleID ) ?>"
   aria-controls="<?php echo esc_attr( $modalID ) ?>"
   aria-label="<?php echo esc_attr( $label ) ?>" title="<?php echo esc_attr( $label ) ?>">
	<span class="<?php echo esc_attr( $this->bemSub( 'play' ) ) ?>"></span>
	<?php
	$this->renderInnerBlocks() ?>
</a>