<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$innerBlocks = new WP_Block_List( $this->innerBlocks );

$paneCls       = $this->bemSub( 'tab-pane' );
$paneActiveCls = $this->bemSub( 'tab-pane--active' );
$paneShowCls   = $this->bemSub( 'tab-pane--show' );
$textAlign     = $this->getAttribute( "textAlign" );
$justify       = $this->renderResponsiveAttributes( [ 'justify' ], false );

$baseAtts = [
	'class' => $this->rootClasses( [], false ),
	'style' => [
		'--tab--color'              => $this->attribute( 'tabsDefaultColor' ),
		'--tab--color-active'       => $this->attribute( 'tabsActiveColor' ),
		'--tab-label--color-active' => $this->attribute( 'activeTextColor' ),
	],
];

?>
<section data-fndry-js="tabs" <?php
fndry_atts( $baseAtts ) ?>>
    <nav <?php
	fndry_atts(
		[
			'data-fndry-js' => 'tabs-nav',
			'class'         => [
				$this->bemSub( 'nav' ),
				$justify,
			],
		]
	) ?>
    >
		<?php
		$count       = 0;
		foreach ( $innerBlocks as $innerBlock ) :
			$attrs = $innerBlock->parsed_block['attrs'];
			$innerId = $attrs['fndryBlockId'] ?? $this->getAttribute( 'fndryBlockId' ) . $count;
			?>
            <button
				<?php
				fndry_atts(
					[
						'class'          => [
							$this->bemSub( 'nav-link' ),
							$this->bemSub( 'nav-link--active' ) => $count === 0,
							$this->bemMod( $textAlign ),
						],
						'data-tab-index' => $count,
						'data-fndry-js'  => 'nav-link',
						'type'           => 'button',
						'role'           => 'tab',
						'aria-controls'  => "fndry-tab-pane__$innerId",
						'id'             => "fndry-tab__$innerId",
					]
				) ?>>
                <span class="<?php
				echo esc_attr( $this->attribute( 'headingStyle' ) ) ?>">
					<?php
					echo wp_kses_post( $attrs['heading'] ?? '' ) ?>
                </span>
            </button>
			<?php
			$count ++; endforeach; ?>
    </nav>
    <div <?php
	fndry_atts( [
		'data-fndry-js' => 'tabs-tabs',
		'class'         => [
			$this->bemSub( 'tabs' ),
			'fndry-responsive-bg',
		],
		'style'         => $this->renderBackground(),
	] ) ?>>
		<?php
		$count = 0;
		foreach ( $innerBlocks as $innerBlock ) :
			$innerId = $attrs['fndryBlockId'] ?? $this->getAttribute( 'fndryBlockId' ) . $count;
			?>
            <div
				<?php
				fndry_atts(
					[
						/* TODO - can't use rootclasses here q_q */
						'class'                  => [
							$paneCls,
							$this->attribute( 'textStyle' ),
							$paneActiveCls => $count === 0,
							$paneShowCls   => $count === 0,
							$innerBlock->parsed_block['attrs']['className'] ?? false,
						],
						'data-tab-content-index' => $count,
						'role'                   => 'tabpanel',
						'id'                     => "fndry-tab-pane__$innerId",
						'aria-labelledby'        => "fndry-tab__$innerId",
					]
				) ?>>
				<?php
				echo $innerBlock->render() ?>
            </div>
			<?php
			$count ++; endforeach; ?>
    </div>
</section>
